package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

import java.util.Collection;

/**
 * This action handles the users list update.
 * It allows the end user to view users lists.
 *
 * @author CS
 */
public class UpdateUsersAction extends AbstractUsersAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(AbstractUsersAction.class);

    @Override
    protected String doExecute() throws Exception {

        String lResult = Action.SUCCESS;

        try {
            if (logger.isDebugEnabled()) {
                logger.debug(getText("fr.onema.sispea.struts.user.action.UpdateUsersAction.debug.doExecute"));
            }

            // set the menu
            openMenu(MenuConstants.MENU_KEY_MYUSERS);

            // check if current user has right
            checkUserAccesRight();

            // get form
            if (getSispeaSession().getUsersSearchInfo() == null) {
                throw new SispeaException("fr.onema.sispea.struts.user.action.UpdateUsersAction.error.noSession");
            }

            // get form from session
            searchUsersInfo = getSispeaSession().getUsersSearchInfo();

            // read users to update
            showUsers(false);

            // deletion
            Collection<UserDto> lUsers = userService.deleteUsers(getCurrentUser(), users, delete, getLocale().getLanguage());

            // update users properties
            userService.updateUsers(getCurrentUser(), lUsers, mandatable, editRight, checkRight, publishRight, suspended, localAdmin, getLocale().getLanguage());

            // reinit password
            userService.reinitPasswordUsers(users, reinitPwd, getLocale().getLanguage(), getSispeaSession().getUser());

            // read once again users
            showUsers(false);

            // success message
            addActionMessage(getText("fr.onema.sispea.struts.user.action.UpdateUsersAction.message.update"));
        } catch (Exception e) {

            // ALWAYS log the errors
            logger.error("Error updating users", e);
            addActionError(getText(e.getMessage()));
            lResult = Action.INPUT;
        }

        // result
        return lResult;
    }

}
