package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

import java.util.List;

/**
 * This action handles the user selections visualization.
 * It allows the end user to save its selections.
 *
 * @author CS
 */
public class UpdateUserSelectionsAction extends AbstractUserSelectionsAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(UpdateUserSelectionsAction.class);

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("update user's selections");
        }

        // init result
        String lResult = Action.SUCCESS;

        // open menu
        openMenu(MenuConstants.MENU_KEY_MYSELECTION);

        try {
            // check submit value
            if (submitValue == null) {
                throw new SispeaException("fr.onema.sispea.jsp.user.updateUserSelections.unknownAction");
            }

            // check territory ids selected
            if (territoryIdsSave == null || territoryIdsSave.size() == 0) {
                throw new SispeaException("fr.onema.sispea.jsp.user.updateUserSelections.missingId");
            }

            // loop on ids to add territories
            for (String lStrTerritoryId : territoryIdsSave) {
                // transform to integer
                Integer lTerritoryId;
                try {
                    lTerritoryId = Integer.valueOf(lStrTerritoryId);
                } catch (NumberFormatException lEx) {
                    throw new SispeaException("fr.onema.sispea.jsp.user.updateUserSelections.wrongFormatId");
                }

                // load ?
                TerritoryDto lTerritory = null;
                if (lTerritoryId != null) {
                    lTerritory = territoryService.readTerritory(lTerritoryId);
                }

                // loaded ?
                if (lTerritory == null) {
                    throw new SispeaException("fr.onema.sispea.jsp.user.updateUserSelections.unknownId=L'identifiant du territoire à ajouter est inconnu.");
                }

                // check user
                if (getCurrentUser() == null) {

                    // user is not authenticated
                    if (getText("fr.onema.sispea.jsp.user.showUserSelections.delete").equals(submitValue)) {
                        // delete
                        getSispeaSession().getSelectedTerritories().remove(lTerritory);
                        addActionMessage(getText("fr.onema.sispea.jsp.user.updateUserSelections.singleDeleted", "", lTerritory.getName()));
                    } else {
                        // add to selection (if not already in)
                        if (!isTerritoryInSelection(lTerritory)) {
                            getSispeaSession().getSelectedTerritories().add(lTerritory);
                            addActionMessage(getText("fr.onema.sispea.jsp.user.updateUserSelections.singleAdded", "", lTerritory.getName()));
                        }
                    }

                } else {
                    // the user is authenticated
                    if (getText("fr.onema.sispea.jsp.user.showUserSelections.delete").equals(submitValue)) {
                        if (lTerritory.getCreator() == null) {
                            // delete single
                            referentialService.removeToUserSelection(getCurrentUser(), lTerritory);
                            addActionMessage(getText("fr.onema.sispea.jsp.user.updateUserSelections.singleDeleted", "", lTerritory.getName()));
                        } else {
                            // delete multiple
                            territoryService.removeTerritoryById(lTerritory.getId());
                            addActionMessage(getText("fr.onema.sispea.jsp.user.updateUserSelections.multipleDeleted", "", lTerritory.getName()));
                        }
                    } else {
                        // add territory to user selection (if not already in)
                        if (!isTerritoryInSelection(lTerritory)) {
                            referentialService.addToUserSelection(getCurrentUser(), lTerritory);
                            addActionMessage(getText("fr.onema.sispea.jsp.user.updateUserSelections.singleAdded", "", lTerritory.getName()));
                        }
                    }
                }

            }

            // Show page
            manageShowSelections();

        } catch (SispeaException lEx) {
            String lMessage = getText(lEx.getMessage());
            logger.error(lMessage);
            addActionError(lMessage);
            lResult = Action.INPUT;
        }

        return lResult;
    }

    protected boolean isTerritoryInSelection(TerritoryDto pTerritory) throws SispeaException {
        boolean lRes;

        try {
            if (getCurrentUser() == null) {
                // the user is not authenticated
                if (getSispeaSession().getSelectedTerritories().indexOf(pTerritory) < 0) {
                    lRes = false;
                } else {
                    lRes = true;
                }

            } else {
                // the user is authenticated
                // read territories
                List<TerritoryDto> lTemp = referentialService.readUserSelections(getCurrentUser());

                if (lTemp == null || lTemp.size() == 0) {
                    lRes = false;
                } else if (lTemp.indexOf(pTerritory) < 0) {
                    lRes = false;
                } else {
                    lRes = true;
                }
            }
        } catch (Exception e) {
            throw new SispeaException(e);
        }

        return lRes;
    }

}
