package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

/**
 * This action handles the user mandates visualization.
 *
 * @author CS
 */
public class UpdateRefuseMandateAction extends AbstractRefuseMandateAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(UpdateRefuseMandateAction.class);

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("refuse mandate - doExecute");
        }

        String lResult = Action.SUCCESS;

        // set the menu
        openMenu(MenuConstants.MENU_KEY_MYMANDATES);
        try {
            // load mandate
            loadMandate();

            // delete mandate
            userService.deleteMandate(mandate.getIds());

            // send notification
            userService.notifyRefuseMandate(getCurrentUser(), mandate, message, getLocale().getLanguage());

            // message sent
            addActionMessage(getText("fr.onema.sispea.jsp.user.refuseMandate.sent"));

        } catch (SispeaException lEx) {
            addActionError(getText(lEx.getMessage()));
            lResult = Action.INPUT;
        }

        return lResult;
    }

}
