package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import fr.onema.sispea.struts.user.bean.UserFormBean;
import org.apache.log4j.Logger;


/**
 * This action handles the user visualization.
 * It allows the end user to view user props.
 *
 * @author CS
 */
public class ShowUserAction extends AbstractUserAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowUserAction.class);

    private static final String RESULT_DELETE = "delete";

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug(getText("fr.onema.sispea.struts.user.action.ShowUserAction.debug.doExecute"));
        }

        // init
        String lRes = Action.SUCCESS;

        if (submitValue != null && submitValue.equals(getText("fr.onema.sispea.jsp.user.showUser.btnDeleteUser"))) {
            lRes = RESULT_DELETE;
        } else {

            // get current user
            UserDto lSessionUser = getCurrentUser();

            // user must be logged
            if (lSessionUser == null) {
                // message
                throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
            }

            // check for parameters : if no login parameter -> current user
            if ((user.getLogin() == null) || (user.getLogin().length() == 0)) {
                // get current user
                user = new UserFormBean(lSessionUser);
            }

            // Display mode : profile or user infos
            Boolean lShowProfile = editingProfile();

            // Menu to display
            String lMenuToDisplay = MenuConstants.MENU_KEY_SEE_USER;
            if (lShowProfile) {
                // Show my profile
                lMenuToDisplay = MenuConstants.MENU_KEY_PROFILE;
            }

            // Set the menu
            openMenu(lMenuToDisplay);

            // compare login to display with current user's login
            if (!lShowProfile) {

                // current user is not visualizing its profile -> check rights :
                // - if current user is not user to display, current user must have editUser
                boolean lCanView = checkUserRight(Right.EditUser);
                if (!lCanView) {
                    // message
                    throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
                }

                // get user from user service
                user = new UserFormBean(userService.readUser(user.getLogin()));

                // check if visualized user's territory is right
                if (user.getTerritory() == null) {
                    lCanView = checkUserRight(Right.Manage);
                } else {
                    lCanView = checkUserRight(Right.EditUser, user.getTerritory(), exerciseService.getCurrentExercise());
                }

                // error ?
                if (!lCanView) {
                    // message
                    throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
                }

            } else {
                // my profile -> current user
                user = new UserFormBean(lSessionUser);
            }

            // Load the mandators and the user's mandates
            user.setMandatedUsers(userService.readMandatesWhereMandated(user, false, false, -1, -1, null, null));
            user.setMandators(userService.readMandatesWhereMandator(user, false, false, -1, -1, null, null));

            // set the form
            setForm();

            // test if user if corrupted
            checkUserCorruption();
        }

        // result
        return lRes;

    }

}
