package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.user.bean.UserFormBean;
import org.apache.log4j.Logger;

/**
 * This action handles the user password re-initialization.
 *
 * @author CS
 */
public class ReinitPwdUserAction extends AbstractUserAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ReinitPwdUserAction.class);

    @Override
    protected String doExecute() throws Exception {

        String lRes;

        if (logger.isDebugEnabled()) {
            logger.debug(getText("fr.onema.sispea.struts.user.action.ReinitPwdUserAction.debug.doExecute"));
        }

        try {
            // let menu as it is

            // get user from ldap
            UserDto lUser = userService.readUser(user.getLogin());

            // reinit pwd
            user = new UserFormBean(userService.reinitPwdUser(lUser, getLocale().getLanguage(), getSispeaSession().getUser(), false, false));

            // message
            addActionMessage(getText("fr.onema.sispea.struts.user.action.ReinitPwdUserAction.message.update"));

            // test if user if corrupted
            checkUserCorruption();

            // We update the lastUpdateDate
            updateLastUpdateDateWithCurrentTime();
            // And we persist it in database
            userService.updateUser(user);

            // result
            lRes = Action.SUCCESS;

        } catch (SispeaException lExp) {

            // log error
            addActionError(getText(lExp.getMessage()));
            lRes = Action.INPUT;

        }

        return lRes;

    }

}
