package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.exchange.thread.AsynchronousService;
import fr.onema.sispea.service.exchange.users.UsersExportParameters;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;


/**
 * This action handles the users download.
 * It allows the end user to download users props.
 *
 * @author CS
 */
public class DownloadUsersAction extends ShowUsersAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(DownloadUsersAction.class);

    /**
     * The asynchronous service handling the batch generations.
     */
    @Autowired
    @Qualifier("usersExportGeneratorService")
    protected transient AsynchronousService batchGenerator;

    @Override
    protected String doExecute() throws Exception {

        String view;

        if (logger.isDebugEnabled()) {
            logger.debug("download users action - do execute");
        }

        // Load the data so the current page can be re-displayed
        view = super.doExecute();

        // get form
        if (getSispeaSession().getUsersSearchInfo() == null) {
            throw new SispeaException("fr.onema.sispea.struts.user.action.DownloadUsersAction.error.noSession");
        }

        // download type
        boolean fullDownload = true;
        if (getText("fr.onema.sispea.jsp.user.showUsers.btnDownload").equals(submitValue)) {
            fullDownload = false;
        }

        boolean lProcessTextFields = getText("fr.onema.sispea.jsp.user.showUsers.btnFilter").equals(searchUsersInfo.getFilter().getSubmitValue());

        // get form from session
        searchUsersInfo = getSispeaSession().getUsersSearchInfo();

        // Prepare the export parameters
        UsersExportParameters parameters = new UsersExportParameters();
        parameters.setFullDownload(fullDownload);
        parameters.setSearchUsersInfo(searchUsersInfo);
        parameters.setFileName(getText("fr.onema.sispea.struts.user.action.DownloadUsersAction.filename"));
        parameters.setDateFormat(getFormatDate());
        parameters.setUser(getCurrentUser());
        parameters.setProcessTextFields(lProcessTextFields);

        // Generate the data model
        batchGenerator.execute(parameters);

        // message
        addActionMessage(getText("fr.onema.sispea.struts.user.action.download.message"));

        // result
        return view;
    }

}
