package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.referential.TerritoryType;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.service.user.UserType;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import fr.onema.sispea.struts.user.bean.UserFormBean;
import org.apache.log4j.Logger;

/**
 * This action handles the user creation.
 * It allows the end user to create a new user.
 *
 * @author CS
 */
public class CreateUserAction extends AbstractUserAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(CreateUserAction.class);

    /**
     * territory id chosen with territory search
     */
    protected Integer territoryId;

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug(getText("fr.onema.sispea.struts.user.action.CreateUserAction.debug.doExecute"));
        }

        // init
        String lRes = Action.SUCCESS;
        boolean lLoadTerritory;
        TerritoryDto lUserTerritory = null;

        // auth user
        UserDto lSessionUser = getCurrentUser();
        if (lSessionUser == null) {
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        // set the menu
        openMenu(MenuConstants.MENU_KEY_SEE_USER);

        // check rights
        if (!checkUserRight(Right.EditUser)) {
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        try {
            // territory id for user
            if ((user.getTerritory() != null) && (user.getTerritory().getId() != null)) {
                territoryId = user.getTerritory().getId();
            }
            lLoadTerritory = (territoryId != null);

            // load territory
            if (lLoadTerritory) {

                // try to read territory
                try {
                    lUserTerritory = territoryService.readTerritory(territoryId);
                } catch (SispeaException lEx) {
                    throw new SispeaException("fr.onema.sispea.struts.user.action.CreateUserAction.error.wrongTerritoryId");
                }
            }

            // Set the check right for DDT users
            boolean checkRight = false;
            if (lUserTerritory != null) {
                if (TerritoryType.DDT.equals(lUserTerritory.getType())) {
                    checkRight = true;
                }
            }

            // Check user right
            TerritoryDto lCurrentTerritory = getCurrentUserTerritory();
            if (lSessionUser.getType() == UserType.Department ||
                lSessionUser.getType() == UserType.Region ||
                lSessionUser.getType() == UserType.Agency ||
                lSessionUser.getType() == UserType.Basin ||
                lSessionUser.getType() == UserType.Municipality ||
                lSessionUser.getType() == UserType.Institutional) {

                // Institutional: restrict to the same territory
                if (!lCurrentTerritory.getId().equals(lUserTerritory.getId())) {
                    throw new SispeaException("fr.onema.sispea.service.user.UserService.errors.territoryDifferentError");
                }
            } else if (lCurrentTerritory != null) {
                // Check if user territory includes chosen territory
                if ((!lCurrentTerritory.isSuperVirtual())
                    && (!territoryService.checkInclusion(lCurrentTerritory, lUserTerritory, exerciseService.getCurrentExerciseId()))) {
                    throw new SispeaException("fr.onema.sispea.service.user.UserService.errors.territoryRightError");
                }
            } else {
                throw new SispeaException("fr.onema.sispea.service.user.UserService.errors.territoryRightError");
            }

            // create a new empty user
            user = new UserFormBean(userService.createUser(lUserTerritory));
            user.setChecker(checkRight);

            // set form as creation form
            user.setForm(user.getCreationFormId());

            // test if user if corrupted
            checkUserCorruption();
        } catch (SispeaException lEx) {
            addActionError(getText(lEx.getMessage()));
            lRes = Action.INPUT;
        }

        // result
        return lRes;
    }

    public Integer getTerritoryId() {
        return territoryId;
    }

    public void setTerritoryId(Integer pTerritoryId) {
        territoryId = pTerritoryId;
    }

}
