package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.common.PagingDto;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.referential.TerritoryPairDto;
import fr.onema.sispea.service.search.BooleanCriterion;
import fr.onema.sispea.service.search.ConnectionType;
import fr.onema.sispea.service.search.SearchFieldDto;
import fr.onema.sispea.service.search.SearchFieldsDto;
import fr.onema.sispea.service.search.SearchTerritoryResultDto;
import fr.onema.sispea.service.search.UsersFilterDto;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.service.user.UserType;
import fr.onema.sispea.struts.referential.action.AbstractUsersManagementAction;
import fr.onema.sispea.util.constants.StringUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * This action handles the users list visualization.
 * It allows the end user to view users lists.
 *
 * @author CS
 */
public abstract class AbstractUsersAction extends AbstractUsersManagementAction {

    private static final long serialVersionUID = 1L;

//    /**
//     * specific paging configuration
//     */
//    public static final Integer USERS_PAGE_SIZE = 15;

    /**
     * specific paging configuration
     */
    private static final Integer USERS_MAIL_STRING_MAX_LENGTH = 20;

//    /**
//     * id of no form.
//     */
//    protected static final int noFormId = 0;

    /**
     * The user's bean list.
     */
    protected Collection<UserDto> users;

    /**
     * The mandatable property of user's list.
     */
    protected List<String> mandatable = new ArrayList<>();

    /**
     * The edit right property of user's list.
     */
    protected List<String> editRight = new ArrayList<>();

    /**
     * The check right property of user's list.
     */
    protected List<String> checkRight = new ArrayList<>();

    /**
     * The publish right property of user's list.
     */
    protected List<String> publishRight = new ArrayList<>();

    /**
     * The suspended property of user's list.
     */
    protected List<String> suspended = new ArrayList<>();

    /**
     * The local admin property of user's list.
     */
    protected List<String> localAdmin = new ArrayList<>();

    /**
     * The reinit pwd property of user's list.
     */
    protected List<String> reinitPwd = new ArrayList<>();

    /**
     * The delete property of user's list.
     */
    protected List<String> delete = new ArrayList<>();

    /**
     * do the job to display users
     *
     * @param pLoadAllUsers if true, all users downloaded, else only current page
     * @throws SispeaException
     */
    protected void showUsers(Boolean pLoadAllUsers) throws SispeaException {
        // check rights
        checkUserAccesRight();

        // get current user reference territory
        TerritoryDto lCurrentTerritory = getCurrentUserTerritory();
        List<TerritoryPairDto> lTerritories = null;

        if (lCurrentTerritory != null) {

            // build filter
            boolean lProcessTextFields = getText("fr.onema.sispea.jsp.user.showUsers.btnFilter").equals(searchUsersInfo.getFilter().getSubmitValue());
            SearchFieldsDto lFilters = searchUsersInfo.getFilter().buildQueryFilter(lProcessTextFields);

            // search for included territory ids
            if (lCurrentTerritory.getIncludedTerritoryIds() == null) {

                List<Integer> lIds = new ArrayList<>();
                if (getCurrentUser().isInstitutionnal()) {
                    // If user is intitutional, we only see users from its own territory
                    lIds.add(lCurrentTerritory.getId());
                    lCurrentTerritory.setIncludedTerritoryIds(lIds);
                } else {
                    // count territories
                    List<SearchTerritoryResultDto> lResult = userService.getPairsIncluded(lCurrentTerritory, true);
                    lTerritories = SearchTerritoryResultDto.getPairs(lResult);

                    // add pairs in territory
                    if (lTerritories != null) {
                        // build territory ids list
                        for (TerritoryPairDto lTerritoryPair : lTerritories) {
                            lIds.add(lTerritoryPair.getChildTerritoryId());
                        }
                        lCurrentTerritory.setIncludedTerritoryIds(lIds);
                    }
                }
            }

            // read included territory ids in current territory
            if (lTerritories == null && lCurrentTerritory.getIncludedTerritoryIds() != null) {
                lTerritories = new ArrayList<>();
                for (Integer lId : lCurrentTerritory.getIncludedTerritoryIds()) {
                    lTerritories.add(new TerritoryPairDto(lCurrentTerritory.getId(), lId));
                }
            }
            // Filter with mail
            String mailValue = null;
            for (SearchFieldDto lFilter : lFilters.getSearchFields()) {
                if ("eMail".equals(lFilter.getSqlFieldName())) {
                    mailValue = (String) lFilter.getHqlValue();
                }
            }
            if (mailValue != null && !getSispeaSession().isLDAPUsersEmailLoaded()) {
                userService.synchronizeUsersLDAP(lTerritories);
                getSispeaSession().setLDAPUsersEmailLoaded(true);
            }

            // count users if first page
            if (searchUsersInfo.getPaging().getGoToPage() == PagingDto.FIRST_PAGE) {
                // get count
                int resultCount = userService.countUsers(lTerritories, false, lFilters);

                // set to results
                searchUsersInfo.getPaging().setResultCount(resultCount);
            }

            // index to load
            int lStartIndex = searchUsersInfo.getPaging().getStartIndex() * searchUsersInfo.getPaging().getPageSize();
            int lResultSize = searchUsersInfo.getPaging().getPageSize();
            if (pLoadAllUsers) {
                lStartIndex = 0;
                lResultSize = searchUsersInfo.getPaging().getResultCount();
            }

            // read users
            users = userService.readUsers(lTerritories, false, lStartIndex, lResultSize, lFilters);

            // page offset
            searchUsersInfo.getPaging().setPageOffset(searchUsersInfo.getPaging().getStartIndex());
        }
    }

    /**
     * check user right and raise exception if not allowed
     *
     * @throws SispeaException
     */
    public void checkUserAccesRight() throws SispeaException {
        // check rights : current user must have editUser
        if (!checkUserRight(Right.EditUser)) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }
    }

    @Override
    public String formatString(String pStr) {
        //format
        String lRes = StringUtils.formatString(pStr, USERS_MAIL_STRING_MAX_LENGTH);

        // result 
        return lRes;
    }

    @Override
    public Map<String, String> getUserTypes() {

        //init list
        Map<String, String> lRes = new TreeMap<>();

        // add empty line
        lRes.put(UsersFilterDto.NO_FILTER_ID.toString(), getText(UsersFilterDto.NO_FILTER_LABEL_KEY));

        // current user
        UserDto lUser = getCurrentUser();
        if (lUser != null) {
            // get the allowed user type for current user
            for (UserType lUserType : lUser.getType().getIncludedTypes()) {
                lRes.put(Integer.valueOf(lUserType.getId()).toString(), getText(lUserType.getLabelKey()));
            }
        }

        return lRes;
    }

    @Override
    public Map<String, String> getConnectionTypes() throws SispeaException {

        //init list
        Map<String, String> lRes = new TreeMap<>();

        // add empty line
        lRes.put(UsersFilterDto.NO_FILTER_ID.toString(), getText(UsersFilterDto.NO_FILTER_LABEL_KEY));

        for (int j = 0; j < ConnectionType.values().length; j++) {
            ConnectionType lConnectionType = ConnectionType.values()[j];
            lRes.put(Integer.valueOf(lConnectionType.getId()).toString(), getText(lConnectionType.getLabelKey()));
        }

        return lRes;
    }

    @Override
    public Map<String, String> getBooleanCriteria() throws SispeaException {

        //init list
        Map<String, String> lRes = new TreeMap<>();

        // add empty line
        lRes.put(UsersFilterDto.NO_FILTER_ID.toString(), getText(UsersFilterDto.NO_FILTER_LABEL_KEY));

        for (int j = 0; j < BooleanCriterion.values().length; j++) {
            BooleanCriterion lBooleanCriterion = BooleanCriterion.values()[j];
            lRes.put(Integer.valueOf(lBooleanCriterion.getId()).toString(), getText(lBooleanCriterion.getLabelKey()));
        }

        return lRes;
    }

    public Collection<UserDto> getUsers() {
        return users;
    }

    public void setUsers(Collection<UserDto> pUsers) {
        users = pUsers;
    }

    public List<String> getMandatable() {
        return mandatable;
    }

    public void setMandatable(List<String> pMandatable) {
        mandatable = pMandatable;
    }

    public List<String> getEditRight() {
        return editRight;
    }

    public void setEditRight(List<String> pEditRight) {
        editRight = pEditRight;
    }

    public List<String> getCheckRight() {
        return checkRight;
    }

    public void setCheckRight(List<String> pCheckRight) {
        checkRight = pCheckRight;
    }

    public List<String> getPublishRight() {
        return publishRight;
    }

    public void setPublishRight(List<String> pPublishRight) {
        publishRight = pPublishRight;
    }

    public List<String> getSuspended() {
        return suspended;
    }

    public void setSuspended(List<String> pSuspended) {
        suspended = pSuspended;
    }

    public List<String> getLocalAdmin() {
        return localAdmin;
    }

    public void setLocalAdmin(List<String> pLocalAdmin) {
        localAdmin = pLocalAdmin;
    }

    public List<String> getReinitPwd() {
        return reinitPwd;
    }

    public void setReinitPwd(List<String> pReinitPwd) {
        reinitPwd = pReinitPwd;
    }

    public List<String> getDelete() {
        return delete;
    }

    public void setDelete(List<String> pDelete) {
        delete = pDelete;
    }

}
