package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.referential.OrganismDto;
import fr.onema.sispea.service.referential.OrganismType;
import fr.onema.sispea.service.referential.ReferentialService;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.struts.AbstractSispeaAction;
import fr.onema.sispea.struts.search.bean.BackType;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * This action handles the user'selections.
 * It allows the end user to view its saved selections.
 *
 * @author CS
 */
public abstract class AbstractUserSelectionMultipleAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

//    private static final Logger logger = Logger.getLogger(UserSelectionMultipleAction.class);

    @Autowired
    protected transient ReferentialService referentialService;

    /**
     * the territory selected
     */
    protected TerritoryDto selection;

    /**
     * the id of the organism to delete
     */
    protected String organismIdDelete;

    /**
     * territory id
     */
    protected String territoryId;

//    @Override
//    protected String doExecute() throws Exception {
//
//        if (logger.isDebugEnabled()) {
//            logger.debug("User multiple selection - shouldn't be called");
//        }
//
//        return Action.SUCCESS;
//    }

    public Integer getBackPageId() {
        return BackType.selections.getId();
    }

    /**
     *
     */
    protected void manageShowUserSelectionMultiple() throws SispeaException {
        try {
            // convert territory id
            Integer lTerritoryIdInt = Integer.valueOf(territoryId);

            // read territories
            selection = territoryService.readTerritory(lTerritoryIdInt);

            // Mantis 3687
            for (OrganismDto organism : selection.getOrganisms()) {
                if (organism.getType() == OrganismType.SPEA) {
                    try {
                        TerritoryDto territoryOfOrganism = territoryService.readTerritory(organism.getId(), OrganismType.SPEA);
                        organism.setName(territoryOfOrganism.getName());
                    } catch (SispeaException e) {
                        //Nothing is done
                    }
                }
            }

        } catch (Exception e) {
            throw new SispeaException(e);
        }

    }

    public TerritoryDto getSelection() {
        return selection;
    }

    public void setSelection(TerritoryDto pSelection) {
        selection = pSelection;
    }

    public String getOrganismIdDelete() {
        return organismIdDelete;
    }

    public void setOrganismIdDelete(String pOrganismIdDelete) {
        organismIdDelete = pOrganismIdDelete;
    }

    public String getTerritoryId() {
        return territoryId;
    }

    public void setTerritoryId(String pTerritoryId) {
        territoryId = pTerritoryId;
    }

}
