package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.referential.TerritoryType;
import fr.onema.sispea.service.search.SearchTerritoryDto;
import fr.onema.sispea.service.search.UsersFilterDto;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.SispeaSession;
import fr.onema.sispea.struts.search.action.AbstractSearchTerritoryAction;

import java.util.List;

/**
 * This action handles the user visualization.
 * It allows the end user to view user props.
 *
 * @author CS
 */

public abstract class AbstractMyRequestsAction extends AbstractSearchTerritoryAction {

    private static final long serialVersionUID = 1L;

//    private static final Logger logger = Logger.getLogger(MyRequestsAction.class);

    /**
     * numAction : the num of request for action.
     */
    protected int numAction;

    /**
     * search id currently edited
     */
    protected int numEdit;

    /**
     * true if editing false else
     */
    protected boolean editing;

    /**
     * the list of searchUserBean
     */
    protected List<UsersFilterDto> mySearchUsers;

//    @Override
//    protected String doExecute() throws Exception {
//
//        if (logger.isDebugEnabled()) {
//            logger.debug("User's selections - sould'nt be called");
//        }
//
//        return Action.SUCCESS;
//    }

    /**
     * Called from Show action and Update action
     *
     * @throws SispeaException
     */
    protected void manageShowMyRequests() throws SispeaException {

        try {
            // get the current user
            UserDto lUser = getCurrentUser();

            if (lUser == null) {
                // session
                SispeaSession lSession = getSispeaSession();
                if (lSession == null) {
                    throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
                }
                // get territory requests in session :
                mySearchsTerritorys = lSession.getMySearchsTerritorys();

                // get user requests in session :
                mySearchUsers = lSession.getMySearchsUsers();

            } else {
                // get territory requests in DB
                mySearchsTerritorys = referentialService.readMySearchTerritorys(lUser);
                // get user requests in DB :
                mySearchUsers = referentialService.readMySearchUsers(lUser);
            }

        } catch (Exception e) {
            throw new SispeaException(e);
        }
    }

    /**
     * @return true if current user can view users
     */
    public boolean canViewUser() {
        //init
        boolean lRes;

        // current user right
        UserDto lUser = getCurrentUser();
        lRes = (lUser != null && lUser.checkRight(Right.EditUser));

        // result
        return lRes;
    }

    public boolean compareTerritorySearch(SearchTerritoryDto sessionSearchTerritoryBean, SearchTerritoryDto searchTerritoryBean) {
        // init
        boolean lTypeIdEquals;
        boolean lTypeEquals;
        boolean lResultKeyWordEquals = false;
        boolean lSearchKeyWordEquals = false;
        boolean lResultTypeEquals = false;
        boolean lSearchTypeEquals = false;


        // test id
        lTypeIdEquals = sessionSearchTerritoryBean.getId().equals(searchTerritoryBean.getId());

        // test search type
        String lSessionResultKeyWord = sessionSearchTerritoryBean.getResultKeywords();
        TerritoryType lSessionResultType = sessionSearchTerritoryBean.getResultType();
        if (sessionSearchTerritoryBean.getIsSimpleSearch()) {
            lSessionResultKeyWord = sessionSearchTerritoryBean.getSimpleResultKeywords();
            lSessionResultType = sessionSearchTerritoryBean.getSimpleResultType();
        }

        String lResultKeyWord = searchTerritoryBean.getResultKeywords();
        TerritoryType lResultType = searchTerritoryBean.getResultType();
        if (searchTerritoryBean.getIsSimpleSearch()) {
            lResultKeyWord = searchTerritoryBean.getSimpleResultKeywords();
            lResultType = searchTerritoryBean.getSimpleResultType();
        }

        // check type
        lTypeEquals = (searchTerritoryBean.getSimpleSearch() == sessionSearchTerritoryBean.getSimpleSearch());
        // result keyword
        if (lResultKeyWord != null && lResultKeyWord.length() == 0) {
            lResultKeyWord = null;
        }
        // result session keyword
        if (lSessionResultKeyWord != null && lSessionResultKeyWord.length() == 0) {
            lSessionResultKeyWord = null;
        }

        // check result key word
        if (lSessionResultKeyWord == null && lResultKeyWord == null) {
            lResultKeyWordEquals = true;
        } else if (lSessionResultKeyWord != null
                   && lSessionResultKeyWord.equalsIgnoreCase(lResultKeyWord)) {
            lResultKeyWordEquals = true;
        }

        // search keyword
        String lModelSearchKeyWord = searchTerritoryBean.getSearchKeywords();
        if (lModelSearchKeyWord != null && lModelSearchKeyWord.length() == 0) {
            lModelSearchKeyWord = null;
        }
        if (sessionSearchTerritoryBean.getSearchKeywords() == null && lModelSearchKeyWord == null) {
            lSearchKeyWordEquals = true;
        } else if (sessionSearchTerritoryBean.getSearchKeywords() != null
                   && sessionSearchTerritoryBean.getSearchKeywords().equalsIgnoreCase(lModelSearchKeyWord)) {
            lSearchKeyWordEquals = true;
        }

        // result type
        if (lSessionResultType == lResultType) {
            lResultTypeEquals = true;
        }

        // search type
        if (sessionSearchTerritoryBean.getTerritoryType() == null && searchTerritoryBean.getTerritoryType() == null) {
            lSearchTypeEquals = true;
        } else if (sessionSearchTerritoryBean.getTerritoryType() != null
                   && sessionSearchTerritoryBean.getTerritoryType() == searchTerritoryBean.getTerritoryType()) {
            lSearchTypeEquals = true;
        }

        //result
        return lTypeIdEquals || (lTypeEquals && lResultKeyWordEquals && lSearchKeyWordEquals
                                 && lResultTypeEquals && lSearchTypeEquals);

    }

    public int getNumAction() {
        return numAction;
    }

    public void setNumAction(int pNumAction) {
        numAction = pNumAction;
    }

    public SearchTerritoryDto getSearchTerritoryBean() {
        return searchTerritoryBean;
    }

    public List<UsersFilterDto> getMySearchUsers() {
        return mySearchUsers;
    }

    public void setMySearchUsers(List<UsersFilterDto> pMySearchUsers) {
        mySearchUsers = pMySearchUsers;
    }

    public boolean isEditing() {
        return editing;
    }

    public void setEditing(boolean pEditing) {
        editing = pEditing;
    }

    public int getNumEdit() {
        return numEdit;
    }

    public void setNumEdit(int pNumEdit) {
        numEdit = pNumEdit;
    }
}
