package fr.onema.sispea.struts.synthesis.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.service.synthesis.ChartValueDto;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 * This class is modeling a category chart value to be rendered by the JWebChart servlet.
 *
 * @author CS
 */
public class CategoryValueBean extends ChartValueDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * The label of the category chart value.
     */
    protected String label = null;

    /**
     * The value of the category chart value.
     */
    protected String value = null;

    public CategoryValueBean() {
        super();
    }

    public CategoryValueBean(String pName, String pLabel, int pValue) {
        super(pName);
        label = pLabel;
        value = String.valueOf(pValue);
    }

    public CategoryValueBean(String pName, String pLabel, double pValue) {
        super(pName);
        label = pLabel;
        value = String.valueOf(pValue);
    }

    @Override
    public String getEncodedValue() throws UnsupportedEncodingException {
        return URLEncoder.encode(label, ENCODING) + SEPARATOR + URLEncoder.encode(value, ENCODING);
    }

    public String getLabel() {
        return label;
    }

    public String getValue() {
        return value;
    }
}
