package fr.onema.sispea.struts.synthesis.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.service.synthesis.ChartDto;

import java.io.Serializable;

/**
 * This class is modeling a category chart to be rendered by the JWebChart servlet.
 *
 * @author CS
 */
public class CategoryChartBean extends ChartDto implements Serializable {

    /**
     * Generated serial version ID.
     * To be used if the type does not undergo structural changes since its first release.
     */
    private static final long serialVersionUID = 1L;

    /**
     * The x label of the chart.
     */
    protected String xLabel = null;

    /**
     * The y label of the chart.
     */
    protected String yLabel = null;

    /**
     * The y max value
     */
    protected Float yMaxValue = null;

    /**
     * Default constructor.
     */
    public CategoryChartBean() {
        super();
    }

    /**
     * @return The series of the chart: Category
     */
    @Override
    public String getSeries() {
        return "Category";
    }

    /**
     * @return The type of the chart: Bar3D
     */
    @Override
    public String getType() {
        return "Bar3D";
    }

    public String getXLabel() {
        return xLabel;
    }

    public void setXLabel(String pLabel) {
        xLabel = pLabel;
    }

    public String getYLabel() {
        return yLabel;
    }

    public void setYLabel(String pLabel) {
        yLabel = pLabel;
    }

    public Float getYMaxValue() {
        return yMaxValue;
    }

    public void setYMaxValue(Float pMaxValue) {
        yMaxValue = pMaxValue;
    }

}
