package fr.onema.sispea.struts.search.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.common.PagingDto;
import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.data.SPEALotDto;
import fr.onema.sispea.service.data.SPEALotStatus;
import fr.onema.sispea.service.referential.OrganismDto;
import fr.onema.sispea.service.referential.SPEADto;
import fr.onema.sispea.service.referential.TerritoryPairDto;
import fr.onema.sispea.service.referential.TerritoryType;
import fr.onema.sispea.service.search.SearchTerritoryDto;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.referential.action.AbstractReferentialCardAction;
import fr.onema.sispea.struts.search.bean.BackType;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * This abstract action is the base class for all territory search actions
 * (two inheriting actions: ShowSearchTerritoryAction and PerformSearchTerritoryAction).
 *
 * @author CS
 */
public abstract class AbstractSearchTerritoryAction extends AbstractReferentialCardAction {

    private static final long serialVersionUID = 1L;

    protected SearchTerritoryDto searchTerritoryBean = new SearchTerritoryDto();

    protected PagingDto paging = new PagingDto();

    /**
     * user for user's territory modification
     */
    protected UserDto user = new UserDto();

    /**
     * the list of searchTerritoryBean
     */
    protected List<SearchTerritoryDto> mySearchsTerritorys;

    /**
     * True if searching territory for a user
     */
    protected boolean searchForUser;

    /**
     * ID of parent mixed territory to add organisms on it.
     */
    protected String territoryId;

    /**
     * the selected territory ids
     */
    protected List<String> territoryIdsSave = new ArrayList<>();

    /**
     * Current multiple selection user's filling
     */
    protected String selectionId;

    /**
     * The page name to go back to
     */
    protected Integer backPage;

//    /**
//     * i18n key prefix
//     */
//    protected static final String PACKAGE_PREFIX_TERRITORY = "fr.cs.jsp.search.searchTerritory.criterion.territory.label.";
//
//    protected static final String PACKAGE_PREFIX_RESULT = "fr.cs.jsp.search.searchTerritory.criterion.result.label.";

    public AbstractSearchTerritoryAction() {
        user = new UserDto();
    }

    /**
     * Get Map of search types.
     *
     * @return Map of search types.
     */
    public Map<String, String> getSearchTypes() {
        Map<String, String> searchTypeMap = new TreeMap<>();

        // add territory types
        for (TerritoryType type : TerritoryType.values()) {
            if (type.getSearchable()) {
                searchTypeMap.put(Integer.valueOf(type.getSortOrder()).toString(), getText(type.getLabelKey()));
            }
        }

        return searchTypeMap;
    }

    /**
     * Get Map of search types.
     *
     * @return Map of search types.
     */
    public Map<String, String> getLotStatusTypes() {
        Map<String, String> lLotStatusTypeMap = new TreeMap<>();

        // add no used
        lLotStatusTypeMap.put(SearchTerritoryDto.UNUSED_FILTER_ID.toString(), getText(SearchTerritoryDto.UNUSED_FILTER_LEBEL_KEY));

        // add status
        for (SPEALotStatus type : SPEALotStatus.values()) {
            lLotStatusTypeMap.put(type.getId().toString(), getText(type.getLabelKey()));
        }

        return lLotStatusTypeMap;
    }

    @Override
    protected void loadExerciseList() throws SispeaException {
        exerciseList = new TreeMap<>();
        exerciseList.put(SearchTerritoryDto.UNUSED_FILTER_ID, getText(SearchTerritoryDto.UNUSED_FILTER_LEBEL_KEY));
        List<ExerciseDto> lExercises = exerciseService.readExercises();
        for (ExerciseDto lExercise : lExercises) {
            exerciseList.put(lExercise.getId(), lExercise.getYear().toString());
        }
    }

    /**
     * Get Map of result types.
     *
     * @return Map of result types.
     */
    public Map<String, String> getResultTypes() {

        // init
        Map<String, String> resultTypeMap = new TreeMap<>();
        boolean lFullList = true;

        // check if choosing user territory
        if (searchingForUserTerritory()) {

            // check if we have a type
            if ((user != null) && (user.getType() != null)) {
                // add territory types corresponding to user type
                TerritoryType lType = user.getType().getTerritoryTypeExpected();
                //resultTypeMap.put(lType.name(), getText(lType.getLabelKey()));
                resultTypeMap.put(Integer.valueOf(lType.getSortOrder()).toString(), getText(lType.getLabelKey()));
                // do not load full list
                lFullList = false;
            }
        }

        if (lFullList) {
            // add territory types for common search
            for (TerritoryType type : TerritoryType.values()) {
                if (type.getResultable()) {
                    resultTypeMap.put(Integer.valueOf(type.getSortOrder()).toString(), getText(type.getLabelKey()));
                }
            }
        }
        return resultTypeMap;
    }

    /**
     * return true if search is for user's territory, false else
     */
    public boolean searchingForUserTerritory() {
        boolean searchingForUserTerritory = false;
        if ((user.getLogin() != null) && (user.getLogin().length() != 0)) {
            searchingForUserTerritory = true;
        } else if (searchForUser) {
            searchingForUserTerritory = true;
        }
        return searchingForUserTerritory;
    }

    /**
     * return true if search is for new user's territory, false else
     */
    public boolean searchingForNewUserTerritory() {
        boolean lRes = false;
        if (searchingForUserTerritory() && user.getId() == null) {
            lRes = true;
        }
        return lRes;
    }

    /**
     * return true if search to fill selections
     */
    public boolean searchingForSelections() {
        boolean lSearchingForSelections = false;
        if ((backPage != null)) {
            lSearchingForSelections = true;
        }
        return lSearchingForSelections;
    }

    /**
     * return true if search is for territory organisms, false otherwise.
     */
    public boolean searchingForTerritoryOrganism() {
        boolean searchingForTerritoryOrganism = false;
        if ((territoryId != null) && (territoryId.length() > 0)) {
            searchingForTerritoryOrganism = true;
        }
        return searchingForTerritoryOrganism;
    }

    /**
     * return true if search is a multiple selection, false otherwise.
     */
    public boolean searchingForFillingMultipleSelection() {
        boolean searchingForFillingMultipleSelection = false;
        if ((selectionId != null) && (!"".equals(selectionId))) {
            searchingForFillingMultipleSelection = true;
        }
        return searchingForFillingMultipleSelection;
    }

//    /**
//     * @return the spea list corresponding to result territory list
//     */
//    public List<SPEADto> getSPEAList() throws SispeaException {
//        // init result
//        List<SPEADto> pSpeas;
//        Collection<TerritoryPairDto> territoryResult = null;
//
//        // if searching for speas, get spea list
//        if (displayDetailsSpea()) {
//            territoryResult = searchTerritoryBean.getTerritoryResults();
//        }
//
//        // exercise
//        ExerciseDto lExercise;
//        if (searchTerritoryBean.getExerciseId() != null
//            && (!searchTerritoryBean.getExerciseId().equals(SispeaConstants.INVALID_INT_ID))) {
//            lExercise = exerciseService.readExercise(searchTerritoryBean.getExerciseId());
//        } else {
//            lExercise = exerciseService.getCurrentExercise();
//        }
//
//        // buildspea list
//        /*if(territoryResult != null) {
//            // fin corresponding spea
//            for (TerritoryPair territory : territoryResult) {
//                // get organism
//                Organism lOrg = territoryService.getOrganismFromTerritoryId(territory.getChildTerritory().getId());
//                // get corresponding spea
//                SPEA lSpea = getReferentialService().readSPEA(lOrg.getId(), lExercise, false);
//                // add to result
//                pSpeas.add(lSpea);
//            }
//        }*/
//        pSpeas = buildSPEAListFromTerritoryResult(territoryResult, lExercise);
//
//        // result
//        return pSpeas;
//    }

    protected List<SPEADto> buildSPEAListFromTerritoryResult(Collection<TerritoryPairDto> pTerritoryResult, ExerciseDto pExercise) throws SispeaException {
        List<SPEADto> pSpeas = new ArrayList<>();
        // buildspea list
        if (pTerritoryResult != null) {
            // fin corresponding spea
            for (TerritoryPairDto territory : pTerritoryResult) {
                // get organism
                OrganismDto lOrg = territoryService.getOrganismFromTerritoryId(territory.getChildTerritoryId());
                // get corresponding spea
                SPEADto lSpea = referentialService.readSPEA(lOrg.getId(), pExercise, false);
                // add to result
                pSpeas.add(lSpea);
            }
        }

        // result
        return pSpeas;
    }

//    public String getSpeaLotStatusAsString(Integer pSpeaId, Integer pExerciseId) {
//        String lRes = "";
//
//        try {
//            if (pSpeaId != null) {
//                Integer lExerciseId = pExerciseId;
//                if (pExerciseId == null || pExerciseId < 0) {
//                    lExerciseId = exerciseService.getCurrentExercise().getId();
//                }
//                SPEALotDto lSpeaLot = speaLotService.readSpeaLot(lExerciseId, pSpeaId, false);
//
//                if (lSpeaLot != null) {
//                    lRes = getText(lSpeaLot.getLotStatus().getLabelKey());
//                }
//            }
//
//        } catch (Exception e) {
//            logException(e);
//        }
//
//        return lRes;
//    }

//    public List<SPEALotDto> getSPEALotList() throws SispeaException {
//
//        // init result
//        List<SPEALotDto> pSpeas = new ArrayList<>();
//        Collection<TerritoryPairDto> territoryResult = null;
//
//        // if searching for speas, get spea list
//        if (displayDetailsSpea()) {
//            territoryResult = searchTerritoryBean.getTerritoryResults();
//        }
//
//        // exercise
//        ExerciseDto lExercise;
//        if (searchTerritoryBean.getExerciseId() != null
//            && (!searchTerritoryBean.getExerciseId().equals(SispeaConstants.INVALID_INT_ID))) {
//            lExercise = exerciseService.readExercise(searchTerritoryBean.getExerciseId());
//        } else {
//            lExercise = exerciseService.getCurrentExercise();
//        }
//
//        // buildspea list
//        if (territoryResult != null) {
//            // fin corresponding spea
//            for (TerritoryPairDto territory : territoryResult) {
//                // get organism
//                OrganismDto lOrg = territoryService.getOrganismFromTerritoryId(territory.getChildTerritory().getId());
//                // get corresponding spea
//                SPEADto lSpea = referentialService.readSPEA(lOrg.getId(), lExercise, false);
//                SPEALotDto lSpeaLot = speaLotService.readSpeaLot(lExercise.getId(), lSpea.getId(), false);
//
//                // add to result
//                pSpeas.add(lSpeaLot);
//            }
//        }
//
//        // result
//        return pSpeas;
//    }


    /**
     * Test if currently logged user is an administrator or not.
     *
     * @return
     */
    public boolean isUserAdmin() {
        boolean lIsAdmin = false;
        if (getSispeaSession() != null && getSispeaSession().getUser() != null) {
            lIsAdmin = getSispeaSession().getUser().checkRight(Right.Manage);
        }
        return lIsAdmin;
    }

    /**
     * @return true if spea details should be displayed
     */
    public Boolean displayDetailsSpea() {
        //init
        Boolean lRes = false;
        TerritoryType lResultType = null;

        // get result type
        if (searchTerritoryBean != null) {
            if (searchTerritoryBean.getIsSimpleSearch()) {
                // simple search
                lResultType = searchTerritoryBean.getSimpleResultType();
            } else {
                // advanced search
                lResultType = searchTerritoryBean.getResultType();
            }
        }

        // test result type
        if ((lResultType != null) && (lResultType == TerritoryType.SPEA)) {
            lRes = true;
        }

        // result
        return lRes;
    }

    /**
     * return true if complementary territory should be displayed
     *
     * @return
     */
    public Boolean displayComplementaryTerritory() {
        //init
        Boolean lRes = false;

        // do not display if simple search
        if ((getSearchTerritory() != null) && (!getSearchTerritory().getIsSimpleSearch())) {
            lRes = true;
        }

        // result
        return lRes;
    }

//    @Override
//    protected TerritoryDto loadTerritory() throws SispeaException {
//        return null;
//    }

    protected void loadMySearchsTerritorys() throws SispeaException {
        // user connected ?
        if (getCurrentUser() == null) {
            // search in session
            mySearchsTerritorys = getSispeaSession().getMySearchsTerritorys();
        } else {
            // search in DB
            mySearchsTerritorys = referentialService.readMySearchTerritorys(getCurrentUser());
        }

        Collections.sort(mySearchsTerritorys);
    }

    /**
     * @return the saved territory search
     */
    public List<SearchTerritoryDto> getMySearchsTerritorys() {
//        if (mySearchsTerritorys == null) {
//
//            // user connected ?
//            if (getCurrentUser() == null) {
//                // search in session
//                mySearchsTerritorys = getSispeaSession().getMySearchsTerritorys();
//            } else {
//                // search in DB
//                mySearchsTerritorys = referentialService.readMySearchTerritorys(getCurrentUser());
//            }
//
//            Collections.sort(mySearchsTerritorys);
//        }
        return mySearchsTerritorys;
    }

    // Getters and setters

    public void setMySearchsTerritorys(List<SearchTerritoryDto> pMySearchsTerritorys) {
        mySearchsTerritorys = pMySearchsTerritorys;
    }

    public int getSimpleSearchCount() throws SispeaException {
        int lRes = 0;

        if (getMySearchsTerritorys() != null) {
            for (SearchTerritoryDto lSearchTerritoryBean : getMySearchsTerritorys()) {
                if (lSearchTerritoryBean.getIsSimpleSearch()) {
                    lRes = lRes + 1;
                }
            }
        }

        // result
        return lRes;
    }

    public int getAdvancedSearchCount() throws SispeaException {
        int lRes = 0;

        if (getMySearchsTerritorys() != null) {
            for (SearchTerritoryDto lSearchTerritoryBean : getMySearchsTerritorys()) {
                if (!lSearchTerritoryBean.getIsSimpleSearch()) {
                    lRes = lRes + 1;
                }
            }
        }

        // result
        return lRes;
    }

    public String getExerciseYear(Integer pExerciseId) throws SispeaException {
        Map<Integer, String> lExercises = getExerciseList();
        return lExercises.get(pExerciseId);
    }

    public String getTerritoryId() {
        return territoryId;
    }

    public void setTerritoryId(String pTerritoryId) {
        territoryId = pTerritoryId;
    }

    public SearchTerritoryDto getSearchTerritory() {
        return searchTerritoryBean;
    }

    public UserDto getUser() {
        return user;
    }

    public void setUser(UserDto pUser) {
        user = pUser;
    }

    public PagingDto getPaging() {
        return paging;
    }

    public boolean isSearchForUser() {
        return searchForUser;
    }

    public void setSearchForUser(boolean pSearchForUser) {
        searchForUser = pSearchForUser;
    }

    public List<String> getTerritoryIdsSave() {
        return territoryIdsSave;
    }

    public void setTerritoryIdsSave(List<String> pTerritoryIdsSave) {
        territoryIdsSave = pTerritoryIdsSave;
    }

    public Integer getBackPage() {
        return backPage;
    }

    public void setBackPage(Integer pBackPage) {
        backPage = pBackPage;
    }

    public String getBackPageLabelKey() {
        return BackType.parse(backPage).getLabelKey();
    }

    public String getSelectionId() {
        return selectionId;
    }

    public void setSelectionId(String pSelectionId) {
        selectionId = pSelectionId;
    }

//    public boolean getDisplayDepartment() {
//        return getCurrentUser().getType() == UserType.SPEA
//               || getCurrentUser().getType() == UserType.Collectivity;
//    }

    protected Map<Integer, String> computeSpeaLotStatusMap(List<SPEADto> speaList, Integer exerciseId) throws SispeaException {

        Map<Integer, String> speaLotStatusMap = new HashMap<>();

        for (SPEADto speaDto : speaList) {

            Integer speaId = speaDto.getId();

            try {
                if (speaId != null) {

                    SPEALotDto lSpeaLot = speaLotService.readSpeaLot(exerciseId, speaId, false);

                    String lRes = "";
                    if (lSpeaLot != null) {
                        lRes = getText(lSpeaLot.getLotStatus().getLabelKey());
                    }

                    speaLotStatusMap.put(speaId, lRes);
                }

            } catch (Exception e) {
                logException(e);
            }

        }
        return speaLotStatusMap;

    }

}
