package fr.onema.sispea.struts.referential.xml;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.struts.referential.bean.XmlData;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.log4j.Logger;

import java.io.InputStream;
import java.net.URL;

/**
 * This class is a support class to read the incoming files.
 *
 * @author CS
 */
public class XmlDataReader {

    private static final Logger logger = Logger.getLogger(XmlDataReader.class);

    /**
     * This method parses the file pFile
     *
     * @param pDatafileInClasspath The file to parse. The parameter gives the absolute classpath location of the file.
     * @throws SispeaException
     */
    public XmlData parse(String pDatafileInClasspath) throws SispeaException {
        try {
            // Create a digester
            //URL ruleFile = getUrl("/fr/onema/sispea/struts/referential/action/dataRules.xml");
            URL ruleFile = getUrl("/fr/onema/sispea/struts/referential/action/dataGroupsRules.xml");
            Digester digester = DigesterLoader.createDigester(ruleFile);

            // Open menu xml file
            InputStream lDataStream = getClass().getResourceAsStream(pDatafileInClasspath);

            // Parse the file
            XmlData lXmlData = (XmlData) digester.parse(lDataStream);
            if ((logger.isDebugEnabled()) && (lXmlData == null)) {
                logger.debug("root data is null !!");
            }
            return lXmlData;
        } catch (Exception e) {
            String msg = "Error while parsing uploaded file: " + pDatafileInClasspath;
            logger.error(msg, e);
            throw new SispeaException(msg, e);
        }
    }

    /**
     * This method returns the URL of the file pName.
     * pName must be the access path in the classpath to the file.
     * URL returned is validated.
     *
     * @param pName Access path in the classpath to the file
     * @return The URL to access the file.
     * @throws SispeaException If the file pName can not be accessed.
     */
    protected URL getUrl(String pName) throws SispeaException {

        URL url = getClass().getResource(pName);

        // Test that the url is valid and a file
        if (url == null) {
            // Cannot find the file in the classpath
            String msg = "Cannot find the file in the classpath: " + pName;
            logger.error(msg);
            throw new SispeaException(msg);
        }
        return url;
    }

}
