package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.service.referential.OrganismDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

import java.util.Collection;
import java.util.HashMap;

/**
 * This action update a territory.
 *
 * @author CS
 */
public class UpdateTerritoryAction extends AbstractTerritoryAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(UpdateTerritoryAction.class);

    /**
     * true if current user can view this territory's users
     */
    protected boolean canViewUsers;

    @Override
    protected String doExecute() throws Exception {
        String lResult = SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("update Territory");
        }

        // Open menu according to the current JSP item.
        openMenu(MenuConstants.MENU_KEY_SEE_TERRITORY);

        // check exercise
        checkExercise();

        // check territory
        checkTerritory();

        canViewUsers = computeCanViewUsers(getCurrentUser(), territory, exercise);

        // load users ?
        if (canViewUsers) {
            loadTerritoryUsers(territory);
        }

        // load speas
        loadTerritorySpeas(territory, exercise);

        // If territory exists...
        if (territory != null) {

            /**
             * MANAGE TERRITORY NAME EDITION.
             */
            if (submitValue.equals(getText(TERRITORY_PREFIX + "cancelName"))) {
                // Territory name is no more modified.
                modifName = false;
            } else if (submitValue.equals(getText(TERRITORY_PREFIX + "saveName"))) {

                // Update territory name.
                territory.setName(territoryName);

                // Save territory into the database.
                referentialService.updateTerritory(territory);

                // Territory name is no more modified.
                modifName = false;

            } else if (submitValue.equals(getText(TERRITORY_PREFIX + "modifyName"))) {
                // Territory name is being modified.
                modifName = true;
            }
            /**
             * MANAGE ORGANISMS EDITION.
             */
            else if (submitValue.equals(getText(TERRITORY_PREFIX + "modifyOrganisms"))) {

                // Update pagination indexes.
                manageOrganismPaging();

                // Territory organisms are being modified.
                modifOrganisms = true;

            } else if (submitValue.equals(getText(TERRITORY_PREFIX + "removeFromTerritory"))) {

                // Get list of all organisms ID to remove and update the organisms list.
                Collection<OrganismDto> lOrganisms = territory.getOrganisms();

                // Create a map of current organisms in this territory.
                HashMap<String, OrganismDto> lMap = new HashMap<>();

                // For each organism associated to this territory...
                for (OrganismDto lOrg : lOrganisms) {
                    lMap.put(lOrg.getId().toString(), lOrg);
                }

                // For each organism to remove...
                for (String lOrgId : getOrganismsToRemove()) {

                    // Test if it exists in the current list of this territory (by looking in the previously built HashMap).
                    if (lMap.containsKey(lOrgId)) {
                        // Remove this organism from the territory list.
                        lOrganisms.remove(lMap.get(lOrgId));
                    }
                }

                // Save territory into the database.
                referentialService.updateTerritory(territory);

                // Update pagination indexes.
                manageOrganismPaging();

                // Territory organisms are no more modified.
                modifOrganisms = false;
            }
        }

        return lResult;
    }

    public boolean isCanViewUsers() {
        return canViewUsers;
    }

    public void setCanViewUsers(boolean canViewUsers) {
        this.canViewUsers = canViewUsers;
    }

}




