package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.VPValueDto;
import fr.onema.sispea.struts.referential.bean.XmlGroupTab;
import fr.onema.sispea.struts.referential.bean.XmlGroupTableDetail;
import fr.onema.sispea.struts.referential.bean.XmlGroupTableDetailValue;
import org.apache.log4j.Logger;

import java.util.ArrayList;

/**
 * This action update taxes of a SPEA.
 *
 * @author CS
 */
public class UpdateTaxesEditorAction extends AbstractTaxesEditorAction {

    private static final long serialVersionUID = 1L;

    private static final String BACK_TO_SPEA_DATA = "back";

    private static final Logger logger = Logger.getLogger(UpdateTaxesEditorAction.class);

    @Override
    protected String doExecute() throws Exception {
        // init result
        String lResult = Action.SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("show spea indicators");
        }
        // check exercise
        checkExerciseParameter();

        // check if spea exists
        loadSpea(exercise);

        // search for group detailed
        XmlGroupTableDetailValue lXmlGroupDetailed = getSispeaSession().getXmlCurrentGroupDetailed();

        // search for group detailed
        XmlGroupTableDetail lXmlGroupToDetail = getSispeaSession().getXmlCurrentGroupToDetail();

        try {
            // test submit button value
            if (submitValue == null) {
                throw new SispeaException("fr.onema.sispea.dataDetail.jsp.showPriceEditor.error.unknownAction");
            }

            if (submitValue.equals(getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.button.cancel"))) {

                // remove current xmlDisplayGroup to session
                getSispeaSession().setXmlCurrentGroupDetailed(null);
                getSispeaSession().setXmlCurrentGroupToDetail(null);

                // result
                lResult = BACK_TO_SPEA_DATA;

            } else if (submitValue.equals(getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.button.refresh"))) {
                // refresh

                // check if values are float
                checkValueFormat(lXmlGroupToDetail);

                // recompute
                reCompute(lXmlGroupDetailed, lXmlGroupToDetail);

            } else if (submitValue.equals(getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.button.save"))) {
                //save

                // check if values are float
                checkValueFormat(lXmlGroupToDetail);

                // recompute
                reCompute(lXmlGroupDetailed, lXmlGroupToDetail);

                // get  xml groups from sispea session
                ArrayList<XmlGroupTab> lXmlGroupTabs = (ArrayList<XmlGroupTab>) getSispeaSession().getXmlGroups();

                // replace group detailed and group to detail
                for (XmlGroupTab lXmlGroupTab : lXmlGroupTabs) {
                    lXmlGroupTab.replaceBoth(lXmlGroupDetailed, lXmlGroupToDetail);
                }

                // result -> return to spea data display
                lResult = BACK_TO_SPEA_DATA;
            }

        } catch (SispeaException lEx) {
            addActionError(lEx.getMessage());
            lResult = Action.INPUT;
        }

        // result
        return lResult;
    }

    /**
     * check if values from detail taxes are float
     */
    protected void checkValueFormat(XmlGroupTableDetail pXmlGroupTableDetail) throws SispeaException {

        // iterate over subgroups of detail tax group
        for (XmlGroupTableDetailValue lXmlGroupTableDetailValue : pXmlGroupTableDetail.getGroupTableDetailValues()) {
            // the Data value
            VPValueDto lDataValue = (VPValueDto) lXmlGroupTableDetailValue.getValue();

            // check format
            if (lDataValue != null && lDataValue.getValue() != null && lDataValue.getValue().length() > 0) {
                try {
                    String lValue = lDataValue.getValue().replace(',', '.').replaceAll("\\s+", "");
                    Double.valueOf(lValue);
                } catch (Exception e) {
                    String lMessage = getText("fr.onema.sispea.dataDetail.jsp.showTaxesEditor.error.notANumber", "", lDataValue.getVp().getCode());
                    throw new SispeaException(lMessage, e);
                }
            }
        }
    }
}
