package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.DataDetailValueDto;
import fr.onema.sispea.service.data.DataFloatValueDto;
import fr.onema.sispea.struts.referential.bean.XmlGroupTab;
import fr.onema.sispea.struts.referential.bean.XmlGroupTableDetail;
import fr.onema.sispea.struts.referential.bean.XmlGroupTableDetailValue;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/**
 * This action show price detail of a SPEA.
 *
 * @author CS
 */
public class UpdatePriceEditorAction extends AbstractPriceEditorAction {

    private static final long serialVersionUID = 1L;

    private static final String BACK_TO_SPEA_DATA = "back";

    private static final Logger logger = Logger.getLogger(UpdatePriceEditorAction.class);

    @Override
    protected String doExecute() throws Exception {
        // init result
        String lResult = Action.SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("show spea indicators");
        }

        // check exercise
        checkExerciseParameter();

        // check if spea exists
        loadSpea(exercise);

        // search for group detailed
        XmlGroupTableDetailValue lXmlGroupDetailed = getSispeaSession().getXmlCurrentGroupDetailed();

        // search for group detailed
        XmlGroupTableDetail lXmlGroupToDetail = getSispeaSession().getXmlCurrentGroupToDetail();
        Collections.sort(lXmlGroupToDetail.getGroupTableDetailValues());

        // in the Detail detailed, a simple detail value contains the value detailed
        code = lXmlGroupDetailed.getCode();
        detailType = lXmlGroupDetailed.getType();

        try {

            // test submit button value
            if (submitValue == null) {
                throw new SispeaException("fr.onema.sispea.dataDetail.jsp.showPriceEditor.error.unknownAction");
            }

            // cancel edit
            if (submitValue.equals(getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.button.cancel"))) {

                // remove current xmlDisplayGroup to session
                getSispeaSession().setXmlCurrentGroupDetailed(null);
                getSispeaSession().setXmlCurrentGroupToDetail(null);

                // result
                lResult = BACK_TO_SPEA_DATA;

            } else if (submitValue.equals(getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.delete"))) {

                // Remove selected slice from xml group to detail
                removeSliceFromCurrentDisplayGroup(lXmlGroupToDetail, sliceId);

                // recompute
                reCompute(lXmlGroupDetailed, lXmlGroupToDetail);

            } else if (submitValue.equals(getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.button.addSlice"))) {

                // check bound value
                Double lBoundValue;
                try {
                    boundValue = boundValue.replace(',', '.').replaceAll("\\s+", "");
                    lBoundValue = Double.valueOf(boundValue.replace(',', '.').replaceAll("\\s+", ""));
                } catch (Exception e) {
                    String lMessage = getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.error.addSlice.notANumber");
                    addFieldError("boundValue", lMessage);
                    throw new SispeaException(lMessage, e);
                }

                Long lUpperBound;
                try {
                    lUpperBound = Long.valueOf(upperBound);
                } catch (Exception e) {
                    String lMessage = getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.error.upperBound.notANumber");
                    addFieldError("upperBound", lMessage);
                    throw new SispeaException(lMessage, e);
                }

                // add slice
                addSlice(lXmlGroupToDetail, lUpperBound, lBoundValue);

                // recompute
                reCompute(lXmlGroupDetailed, lXmlGroupToDetail);

            } else if (submitValue.equals(getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.button.refresh"))) {

                // refresh screen
                reCompute(lXmlGroupDetailed, lXmlGroupToDetail);

            } else if (submitValue.equals(getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.button.save"))) {
                // save

                // recompute
                reCompute(lXmlGroupDetailed, lXmlGroupToDetail);

                // get  xml groups from sispea session
                ArrayList<XmlGroupTab> lXmlGroupTabs = (ArrayList<XmlGroupTab>) getSispeaSession().getXmlGroups();

                // replace group detailed and group to detail
                for (XmlGroupTab lXmlGroupTab : lXmlGroupTabs) {
                    lXmlGroupTab.replaceBoth(lXmlGroupDetailed, lXmlGroupToDetail);
                }

                // result -> return to spea data display
                lResult = BACK_TO_SPEA_DATA;

            }

        } catch (SispeaException lEx) {
            addActionError(lEx.getMessage());
            lResult = Action.INPUT;
        }

        // result
        return lResult;
    }

    /**
     * refresh values displayed reflecting recent changes
     */
    protected void reCompute(XmlGroupTableDetailValue pXmlGroupDetailed, XmlGroupTableDetail pXmlGroupToDetail) {

        // formula too compute : groupDetailed value equals to fix part + variable part
        // - fix part = group value with upperbound = 0
        // - variable part = sum of slices values (upper bound > 0) : a computed slice value equals to (upper bound - lower bound) * slice value

        // init
        Double lFixPartValue = 0.0;
        Double lVariablePartValue = 0.0;

        // get the value to update
        DataFloatValueDto lValueToUpdate = (DataFloatValueDto) pXmlGroupDetailed.getValue();

        // loop on detail values to get slice part sum
        for (XmlGroupTableDetailValue lXmlGroupTableDetailValue : pXmlGroupToDetail.getGroupTableDetailValues()) {
            // witch type of value
            if (lXmlGroupTableDetailValue.isSliceValue()) {
                DataDetailValueDto lValue = (DataDetailValueDto) lXmlGroupTableDetailValue.getValue();
                if (!lValue.isEmpty()) {
                    lVariablePartValue = lVariablePartValue + lValue.getFloatValue() * (lValue.getUpperBound() - lValue.getLowerBound());
                }
            } else if (!lXmlGroupTableDetailValue.isPriceValue()) {
                DataFloatValueDto lValue = (DataFloatValueDto) lXmlGroupTableDetailValue.getValue();
                if (!lValue.isEmpty()) {
                    lFixPartValue = lFixPartValue + lValue.getFloatValue();
                }
            }
        }

        // loop on values to set variable part
        for (XmlGroupTableDetailValue lXmlGroupTableDetailValue : pXmlGroupToDetail.getGroupTableDetailValues()) {
            if (lXmlGroupTableDetailValue.isPriceValue()) {
                DataFloatValueDto lValue = (DataFloatValueDto) lXmlGroupTableDetailValue.getValue();
                lValue.setFloatValue(lVariablePartValue);
            }
        }

        // update price
        lValueToUpdate.setFloatValue(lVariablePartValue + lFixPartValue);

        // sort slices
        Collections.sort(pXmlGroupToDetail.getGroupTableDetailValues());
    }

    /**
     * add a new xmlDisplayGroup representing a slice into sispeaSession
     *
     * @param pXmlGroupTableDetail
     * @throws SispeaException
     */
    protected void addSlice(XmlGroupTableDetail pXmlGroupTableDetail, Long pUpperBound, Double pSliceValue) throws SispeaException {

        // sort dataDetailValue by upper bound
        List<Long> lUpperBoundList = getUpperBoundList(pXmlGroupTableDetail);

        // sort dataDetailValue by lower bound
        List<Long> lLowerBoundList = getLowerBoundList(pXmlGroupTableDetail);

        // check if bound already exists
        if (lUpperBoundList.contains(pUpperBound)) {
            addActionError(getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.error.addSlice.boundAlreadyExists"));
        } else if (lLowerBoundList.contains(pUpperBound)) {
            addActionError(getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.error.addSlice.boundAlreadyExists"));
        } else if (pUpperBound.intValue() > DataDetailValueDto.DEFAULT_UPPER_BOUND) {
            addActionError(getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.error.addSlice.boundTohigh"));
        } else {

            // find a slice to copy
            XmlGroupTableDetailValue lNewSliceValue = null;
            for (Iterator<XmlGroupTableDetailValue> iterator = pXmlGroupTableDetail.getGroupTableDetailValues().iterator(); iterator.hasNext() && lNewSliceValue == null; ) {
                XmlGroupTableDetailValue lXmlGroupTableDetailValue = iterator.next();
                if (lXmlGroupTableDetailValue.isSliceValue()) {
                    lNewSliceValue = lXmlGroupTableDetailValue.clone();
                }
            }

            // set Id
            lNewSliceValue.setId(passwordService.generateNewPassword());

            // change DataDetailValue
            DataDetailValueDto lOldValue = (DataDetailValueDto) lNewSliceValue.getValue();
            DataDetailValueDto lDataDetailValue = new DataDetailValueDto(lOldValue.getDataDetail(), lOldValue.getUpperBound(), lOldValue.getLowerBound(), lOldValue.getFloatValue());
            lNewSliceValue.setValue(lDataDetailValue);

            // remove comment
            lNewSliceValue.setComment(null);

            // Get min bound
            lowerBound = getMinBound(lUpperBoundList, pUpperBound);

            // create dataDetailValue
            DataDetailValueDto lDetailValue = (DataDetailValueDto) lNewSliceValue.getValue();
            lDetailValue.setUpperBound(pUpperBound);
            lDetailValue.setLowerBound(lowerBound);
            lDetailValue.setValue(boundValue);
            //set FloatValue
            try {
                Double.valueOf(boundValue);
            } catch (Exception e) {
                String lMessage = getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.error.addSlice.notANumber");
                addFieldError("boundValue", lMessage);
                throw new SispeaException(lMessage, e);
            }
            lDetailValue.setFormattedFloatValue(boundValue);

            //add the new slice xml display group
            pXmlGroupTableDetail.add(lNewSliceValue);

            // refresh bounds
            refreshBounds(pXmlGroupTableDetail);
        }
    }

    /**
     * get min bound from upperBound list
     *
     * @param upperBoundList
     * @return
     */
    protected Long getMinBound(List<Long> upperBoundList, Long pCurrentUpperBound) {
        // init
        Long lRes = (long) 0;

        for (Long lBound : upperBoundList) {
            if (pCurrentUpperBound > lBound && lBound > lRes) {
                // set the min bound value
                lRes = lBound;
            }
        }

        //result
        return lRes;
    }

    /**
     * @param pXmlGroupTableDetail
     * @param pUperBounds
     * @return a list of bound (upper or lower)
     */
    protected List<Long> getBoundList(XmlGroupTableDetail pXmlGroupTableDetail, Boolean pUperBounds) {
        // init
        List<Long> lRes = new ArrayList<>();

        if (pXmlGroupTableDetail != null) {

            // get bound
            for (XmlGroupTableDetailValue lXmlGroupTableDetailValue : pXmlGroupTableDetail.getGroupTableDetailValues()) {
                if (lXmlGroupTableDetailValue.isSliceValue()) {


                    // get the upperBound Value
                    DataDetailValueDto lVal = (DataDetailValueDto) lXmlGroupTableDetailValue.getValue();

                    if (pUperBounds) {
                        // add upperBound to the list
                        lRes.add(lVal.getUpperBound());
                    } else {
                        // add lowerBound to the list
                        lRes.add(lVal.getLowerBound());
                    }
                }
            }
        }
        //result
        return lRes;
    }

    protected List<Long> getUpperBoundList(XmlGroupTableDetail pXmlGroupTableDetail) {
        return getBoundList(pXmlGroupTableDetail, true);
    }

    protected List<Long> getLowerBoundList(XmlGroupTableDetail pXmlGroupTableDetail) {
        return getBoundList(pXmlGroupTableDetail, false);
    }

}
