package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.SispeaInputException;
import fr.onema.sispea.service.common.MessageDto;
import fr.onema.sispea.service.common.MessageType;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import fr.onema.sispea.struts.referential.bean.XmlDisplayGroup;
import org.apache.log4j.Logger;

import java.util.Collection;
import java.util.HashSet;

/**
 * This action show indicators of a SPEA.
 *
 * @author CS
 */
public class UpdateGeneralTabAction extends AbstractSpeaIndicatorsAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(UpdateGeneralTabAction.class);

    /**
     * the general tab xml display group
     */
    protected XmlDisplayGroup generalGroup;

    @Override
    protected String doExecute() throws Exception {
        // init result
        String lResult = Action.SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("update general tab");
        }

        try {
            openMenu(MenuConstants.MENU_KEY_SPEA_DATA);

            // init
            Collection<MessageDto> lMessages = new HashSet<>();

            // check spea id
            checkSpeaParameter();

            // check exercise
            checkExerciseParameter();

            // check if spea exists
            loadSpea(exercise);

            // which action ?
            if ((submitValue != null) && (submitValue.equals(getText("fr.onema.sispea.referential.datagroup.general.submit.commentEdit")))) {

                editingComment = true;

            } else if ((submitValue != null) && (submitValue.equals(getText("fr.onema.sispea.referential.datagroup.general.submit.dataModeEdit")))) {

                editingDataToInput = true;

            } else if ((submitValue != null) && (submitValue.equals(getText("fr.onema.sispea.referential.datagroup.general.submit.autoPublish")))) {

                editingAutopublish = true;

            } else if ((submitValue != null) && (submitValue.equals(getText("fr.onema.sispea.referential.datagroup.generalComment.save")))) {
                String lComment = generalComment;
                try {
                    if (lComment != null && lComment.length() > 1024) {
                        addFieldError("generalComment", getText("fr.onema.sispea.error.field.tooLong", "", "1024"));
                        throw new SispeaInputException("fr.onema.sispea.jsp.fixRef.showSPEAData.error.validation");
                    }

                    // save comment
                    lMessages.addAll(speaLotService.saveLotComment(spea, exercise, lComment, getLocale().getLanguage(), getCurrentUser()));

                } catch (SispeaInputException lEx) {
                    // add to list
                    MessageDto lMessage = new MessageDto("", MessageType.ERROR, lEx.getMessage());
                    lMessage.setArguments(lEx.getArgs());
                    lMessages.add(lMessage);
                    // check parameters and load data
                    manageViewActions(false, false, true);
                    generalComment = lComment;
                }

                // display messages
                boolean lErrorFound = displayResultMessages(lMessages);
                // found error ?
                if (lErrorFound) {
                    lResult = Action.INPUT;
                } else {
                    editingComment = false;
                    editingGroupId = null;
                }

            } else if (submitValue != null && submitValue.equals(getText("fr.onema.sispea.referential.datagroup.generalComment.cancel"))) {
                // don't edit
                editingComment = false;
                editingGroupId = null;
            } else if ((submitValue != null) && (submitValue.equals(getText("fr.onema.sispea.referential.datagroup.editingDataToInput.save")))) {

                // save comment
                lMessages = speaLotService.saveLotInputDataName(spea, exercise, lot.getInputDataName(), getLocale().getLanguage(), getCurrentUser());

                // display messages
                boolean lErrorFound = displayResultMessages(lMessages);
                // found error ?
                if (lErrorFound) {
                    lResult = Action.INPUT;
                } else {
                    editingComment = false;
                    editingGroupId = null;
                }

            } else if (submitValue != null && submitValue.equals(getText("fr.onema.sispea.referential.datagroup.editingDataToInput.cancel"))) {
                // don't edit
                editingDataToInput = false;
                editingGroupId = null;
            } else if ((submitValue != null) && (submitValue.equals(getText("fr.onema.sispea.referential.datagroup.editingAutopublish.save")))) {

                // save comment
                lMessages = speaLotService.saveLotAutopublish(spea, exercise, lot.getAutoPublish(), getLocale().getLanguage(), getCurrentUser());

                // display messages
                boolean lErrorFound = displayResultMessages(lMessages);
                // found error ?
                if (lErrorFound) {
                    lResult = Action.INPUT;
                } else {
                    editingComment = false;
                    editingGroupId = null;
                }

            } else if (submitValue != null && submitValue.equals(getText("fr.onema.sispea.referential.datagroup.editingAutopublish.cancel"))) {
                // don't edit
                editingAutopublish = false;
                editingGroupId = null;
            }

            // if succes -> display db infos
            if (Action.SUCCESS.equals(lResult)) {
                // check parameters and load data
                manageViewActions(false, false, true);
            }

        } catch (SispeaException lEx) {
            lResult = Action.INPUT;
            addActionError(getText("fr.onema.sispea.referential.action.showSpeaIndicators.error.common", "", getText(lEx.getMessage())));
        }

        // result
        return lResult;
    }

//    public String getGeneralComment() {
//        return generalComment;
//    }
//
//    public void setGeneralComment(String pGeneralComment) {
//        generalComment = pGeneralComment;
//    }

    public XmlDisplayGroup getGeneralGroup() {
        return generalGroup;
    }

    public void setGeneralGroup(XmlDisplayGroup pGeneralGroup) {
        generalGroup = pGeneralGroup;
    }

}
