package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.referential.CollectivityDto;
import org.apache.log4j.Logger;

/**
 * This action updates a collectivity.
 *
 * @author CS
 */
public class UpdateCollectivityAction extends ShowCollectivityAction {

    private static final long serialVersionUID = 1L;

    /**
     * HTTP prefix.
     */
    private static final String URL_PREFIX = "http://";

    private static final Logger logger = Logger.getLogger(UpdateCollectivityAction.class);

    public UpdateCollectivityAction() {
        collectivity = new CollectivityDto();
    }

    @Override
    protected String doExecute() throws Exception {

        String nextPage;

        if (logger.isDebugEnabled()) {
            logger.debug("Update collectivity");
        }

        try {
            // Save the link and comment values. They will be overwritten by the showCollectivity load
            String link = collectivity.getLink();
            String comment = collectivity.getComment();

            // Load all needed data for the next page: show collectivity
            nextPage = super.doExecute();

            if (submitValue != null && submitValue.equals(getText("fr.onema.sispea.jsp.fixRef.showCollectivity.submit"))) {

                // Reset the new values
                collectivity.setLink(link);
                collectivity.setComment(comment);

                // Validate the form input parameters
                nextPage = validateFormParameters();

                if (SUCCESS.equals(nextPage)) {

                    // Update the collectivity
                    referentialService.updateCollectivity(collectivity.getId(), collectivity.getLink(), collectivity.getComment());

                    // Add action message
                    addActionMessage(getText("fr.onema.sispea.jsp.fixRef.showCollectivity.updated"));
                }
            }
        } catch (SispeaException e) {
            nextPage = INPUT;
            edit = true;
            String lMessage = getText(e.getMessage());
            addActionError(getText("fr.onema.sispea.jsp.fixRef.showCollectivity.error.main", "", lMessage));
        }

        return nextPage;
    }

    /**
     * Validates the input parameters.
     *
     * @throws SispeaException
     */
    protected String validateFormParameters() throws SispeaException {

        String nextPage = SUCCESS;

        // Validate the link and comment attributes
        if (collectivity.getLink() != null) {
            collectivity.setLink(collectivity.getLink().trim());
            if ("".equals(collectivity.getLink())) {
                collectivity.setLink(null);
            } else {
                if (!collectivity.getLink().startsWith(URL_PREFIX)) {
                    collectivity.setLink(URL_PREFIX + collectivity.getLink());
                }
            }
        }

        if (collectivity.getComment() != null) {
            collectivity.setComment(collectivity.getComment().trim());
            if ("".equals(collectivity.getComment())) {
                collectivity.setComment(null);
            } else {
                // Test the length of the comment
                if (collectivity.getComment().length() > 2000) {
                    edit = true;
                    nextPage = INPUT;
                    addFieldError("collectivity.comment", getText("fr.onema.sispea.jsp.fixRef.showCollectivity.comment.max.lenght"));
                    addActionError(getText("fr.onema.sispea.jsp.fixRef.showCollectivity.error.validation"));
                }
            }
        }

        return nextPage;
    }

}
