package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.DataRatioDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

/**
 * This action show indicators of a SPEA.
 *
 * @author CS
 */
public class ShowSpeaIndicatorsAction extends AbstractSpeaIndicatorsAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowSpeaIndicatorsAction.class);

    /**
     * Store the spea data ratio.
     */
    protected DataRatioDto speaDataRatio;

//    protected Map<String, String> exerciseList;

    @Override
    protected String doExecute() throws Exception {
        // init result
        String lResult = SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("show spea indicators");
        }

        try {

            exerciseList = buildExerciseList();

            // Open menu according to the current JSP item.
            openMenu(MenuConstants.MENU_KEY_SPEA_INDICATORS);

            // check parameters and load data
            manageViewActions(true, false, true);

            speaDataRatio = speaLotService.getDisplayRatio(lot);

        } catch (SispeaException lEx) {
            lResult = Action.INPUT;
            addActionError(getText("fr.onema.sispea.referential.action.showSpeaIndicators.error.common", "", getText(lEx.getMessage())));
        }

        // result
        return lResult;
    }

    public DataRatioDto getSpeaDataRatio() {
        return speaDataRatio;
    }

//    public Map<String, String> getExerciseList() {
//        return exerciseList;
//    }

//    /**
//     * @return true if user has view right, false else
//     */
//    public boolean hasUserViewRight() {
//        //init result
//        boolean lRes = false;
//
//        try {
//            // read territory from spea id
//            TerritoryDto lTerritory = territoryService.readTerritory(id, OrganismType.SPEA);
//
//            if (lTerritory != null) {
//                // check right
//                lRes = checkUserRight(Right.View, lTerritory, exercise);
//            }
//        } catch (SispeaException e) {
//            // don't do anything
//            lRes = false;
//        }
//
//        // result
//        return lRes;
//
//    }

}
