package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.DataRatioDto;
import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.exchange.indicatorRecap.IndicatorRecapParameters;
import fr.onema.sispea.service.exchange.thread.AsynchronousService;
import fr.onema.sispea.service.exchange.waterUseFeeAnnexe.WaterUseFeeAnnexeParameters;
import fr.onema.sispea.service.referential.OrganismDto;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * This action show indicators of a SPEA.
 *
 * @author CS
 */
public class ShowSpeaDataAction extends AbstractSpeaIndicatorsAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowSpeaDataAction.class);

    @Autowired
    @Qualifier("indicatorRecapService")
    protected transient AsynchronousService indicatorRecapService;

    @Autowired
    @Qualifier("waterUseFeeAnnexeService")
    protected transient AsynchronousService waterUseFeeAnnexeService;

    /**
     * Input parameter.
     * Set to true to generate the RPQS for the SPEA.
     */
    protected boolean rpqs;

    /**
     * Input parameter.
     * Set to true to generate the water use fee annexe.
     */
    protected boolean waterUseFee;

    /**
     * Input parameter.
     * Set to true to generate the indicator recapitulate sheet for the SPEA.
     */
    protected boolean indicatorRecap;

    /**
     * Store the spea data ratio.
     */
    protected DataRatioDto speaDataRatio;

//    protected Map<String, String> exerciseList;

    @Override
    protected String doExecute() throws Exception {
        // init result
        String lResult = Action.SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("show spea indicators");
        }

        try {

            exerciseList = buildExerciseList();

            // Open menu according to the current JSP item.
            openMenu(MenuConstants.MENU_KEY_SPEA_DATA);

            // check parameters and load data
            manageViewActions(false, false, true);

            speaDataRatio = speaLotService.getDisplayRatio(lot);

        } catch (SispeaException lEx) {
            lResult = Action.INPUT;
            addActionError(getText("fr.onema.sispea.referential.action.showSpeaIndicators.error.common", "", getText(lEx.getMessage())));
        }
        // check view right for result
        if (!isHasViewRight()) {
            openMenu(MenuConstants.MENU_KEY_SPEA_INDICATORS);
            lResult = "notAllowed";
        }

        // Generate the RPQS
        if (rpqs) {
            generateRpqs(getCurrentUser(), spea, exercise);
        }

        if (indicatorRecap) {
            generateIndicatorRecap(getCurrentUser(), spea, exercise);
        }

        if (waterUseFee) {
            generateWaterUseFeeAnnexe(getCurrentUser(), spea, exercise);
        }

        // result
        return lResult;
    }

    public DataRatioDto getSpeaDisplayRatio() {
        return speaDataRatio;
    }

//    public Map<String, String> getExerciseList() {
//        return exerciseList;
//    }

    /**
     * This method generates the RPQS for the SPEA.
     *
     * @param pCurrentUser
     * @param pOrganism
     * @param pExercise
     * @throws SispeaException
     */
    protected void generateIndicatorRecap(UserDto pCurrentUser, OrganismDto pOrganism, ExerciseDto pExercise) throws SispeaException {

        String territoryName;
        try {
            // If someone tries to access the URL without being connected, the current user
            // will be null.
            // Test the current user to prevent an ugly NullPointerException
            if (pCurrentUser == null) {

                // Error, no rights
                String msg = getText("fr.onema.sispea.referential.jsp.showSpeaIndicators.indicatorRecap.no.access", "utilisateur inconnu", "territoire inconnu");
                logger.error(msg);
                throw new SispeaException(msg);
            }

            // Prepare the export parameters.
            //
            // The export is run with the SPEA territory
            TerritoryDto territory = territoryService.readTerritory(pOrganism);
            territoryName = territory.getName();

            // View right
            Boolean hasViewRight = userService.checkUserRight(pCurrentUser, Right.View, territory, pExercise);
            if (Boolean.FALSE.equals(hasViewRight)) {

                // Error, no rights
                String msg = getText("fr.onema.sispea.referential.jsp.showSpeaIndicators.indicatorRecap.no.access", pCurrentUser.getLogin(), territoryName);
                logger.error(msg);
                throw new SispeaException(msg);
            }

            // Copy all objects as the export is run by another thread
            IndicatorRecapParameters parameters = new IndicatorRecapParameters();
            parameters.setExerciseId(pExercise.getId());
            parameters.setSpeaId(pOrganism.getId());
            parameters.setUser(new UserDto(pCurrentUser));

            // Generate the export
            indicatorRecapService.execute(parameters);

            addActionMessage(getText("fr.onema.sispea.referential.jsp.showSpeaIndicators.indicatorRecap.generating"));
        } catch (Exception e) {
            logException(e);
            throw new SispeaException(getText("fr.onema.sispea.referential.jsp.showSpeaIndicators.indicatorRecap.error"));
        }
    }


    /**
     * This method generates the water use fee annexe
     *
     * @param pCurrentUser
     * @param pOrganism
     * @param pExercise
     * @throws SispeaException
     */
    protected void generateWaterUseFeeAnnexe(UserDto pCurrentUser, OrganismDto pOrganism, ExerciseDto pExercise) throws SispeaException {

        String territoryName;
        try {
            // If someone tries to access the URL without being connected, the current user
            // will be null.
            // Test the current user to prevent an ugly NullPointerException
            if (pCurrentUser == null) {

                // Error, no rights
                String msg = getText("fr.onema.sispea.referential.jsp.showSpeaIndicators.waterUseFeeAnnexe.no.access", "utilisateur inconnu", "territoire inconnu");
                logger.error(msg);
                throw new SispeaException(msg);
            }

            // Prepare the export parameters.
            //
            // The export is run with the SPEA territory
            TerritoryDto territory = territoryService.readTerritory(pOrganism);
            territoryName = territory.getName();

            // View right
            Boolean hasViewRight = userService.checkUserRight(pCurrentUser, Right.View, territory, pExercise);
            if (Boolean.FALSE.equals(hasViewRight)) {

                // Error, no rights
                String msg = getText("fr.onema.sispea.referential.jsp.showSpeaIndicators.waterUseFeeAnnexe.no.access", pCurrentUser.getLogin(), territoryName);
                logger.error(msg);
                throw new SispeaException(msg);
            }

            // Copy all objects as the export is run by another thread
            WaterUseFeeAnnexeParameters parameters = new WaterUseFeeAnnexeParameters();
            parameters.setExerciseId(pExercise.getId());
            parameters.setSpeaId(pOrganism.getId());
            parameters.setUser(new UserDto(pCurrentUser));

            // Generate the export
            waterUseFeeAnnexeService.execute(parameters);

            addActionMessage(getText("fr.onema.sispea.referential.jsp.showSpeaIndicators.waterUseFeeAnnexe.generating"));
        } catch (Exception e) {
            logException(e);
            throw new SispeaException(getText("fr.onema.sispea.referential.jsp.showSpeaIndicators.waterUseFeeAnnexe.error"));
        }
    }

    public boolean isRpqs() {
        return rpqs;
    }

    public void setRpqs(boolean pRpqs) {
        rpqs = pRpqs;
    }

    public boolean isIndicatorRecap() {
        return indicatorRecap;
    }

    public void setIndicatorRecap(boolean pIndicatorRecap) {
        indicatorRecap = pIndicatorRecap;
    }

    public boolean isWaterUseFee() {
        return waterUseFee;
    }

    public void setWaterUseFee(boolean waterUseFee) {
        this.waterUseFee = waterUseFee;
    }

}
