package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import fr.onema.sispea.struts.referential.bean.XmlGroupTab;
import fr.onema.sispea.struts.referential.bean.XmlGroupTableDetail;
import fr.onema.sispea.struts.referential.bean.XmlGroupTableDetailValue;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.Collections;

/**
 * This action show price detail of a SPEA.
 *
 * @author CS
 */
public class ShowPriceEditorAction extends AbstractPriceEditorAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowPriceEditorAction.class);

    @Override
    protected String doExecute() throws Exception {
        // init result
        String lResult = SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("show price editor");
        }

        try {
            // Open menu according to the current JSP item.
            openMenu(MenuConstants.MENU_KEY_SPEA_INDICATORS);

            // check exercise
            checkExerciseParameter();

            // check if spea exists
            loadSpea(exercise);

            // get  xml groups from sispea session 
            ArrayList<XmlGroupTab> lXmlGroupTabs = (ArrayList<XmlGroupTab>) getSispeaSession().getXmlGroups();

            // search for group detailed
            XmlGroupTableDetailValue lXmlGroupDetailed = XmlGroupTab.findTableDetailValueInTableDetail(xmlGroupTableDetailContainingValueDetailedId, lXmlGroupTabs, true);
            if (lXmlGroupDetailed == null) {
                throw new SispeaException("fr.onema.sispea.dataDetail.jsp.showPriceEditor.error.noGroupDetailed");
            }

            // search for group detailed
            XmlGroupTableDetail lXmlGroupToDetail = XmlGroupTab.findTableDetail(xmlGroupTableDetailToDetailId, lXmlGroupTabs, true);
            if (lXmlGroupToDetail == null) {
                throw new SispeaException("fr.onema.sispea.dataDetail.jsp.showPriceEditor.error.noGroupToDetail");
            }
            Collections.sort(lXmlGroupToDetail.getGroupTableDetailValues());

            // add current xmlDisplayGroup to session
            getSispeaSession().setXmlCurrentGroupDetailed(lXmlGroupDetailed);
            getSispeaSession().setXmlCurrentGroupToDetail(lXmlGroupToDetail);


            // in the Detail detailed, a simple detail value contains the value detailed
            code = lXmlGroupDetailed.getCode();
            detailType = lXmlGroupToDetail.getType();

        } catch (SispeaException lEx) {
            lResult = Action.INPUT;
            addActionError(getText("fr.onema.sispea.referential.action.showSpeaIndicators.error.common", "", getText(lEx.getMessage())));
        }

        // result
        return lResult;
    }

}
