package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

/**
 * This action display a comparator.
 *
 * @author CS
 */
public class ShowComparatorAction extends AbstractComparatorAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowComparatorAction.class);

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("show comparator");
        }

        // init result
        String result = SUCCESS;
        // Open menu according to the current JSP item.
        openMenu(MenuConstants.MENU_KEY_COMPARATOR);

        try {

            loadComparator();

        } catch (SispeaException lEx) {
            logger.error(lEx.getMessage());
            addActionError(lEx.getMessage());
            result = INPUT;
        }

        // result
        return result;
    }

}
