package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.referential.OrganismDto;

/**
 * This action display a collectivity.
 *
 * @author CS
 */
public class ShowCollectivityFrAction extends ShowCollectivityAction {

    private static final long serialVersionUID = 1L;

    /**
     * year to get the exercise from
     */
    private String annee;

    /**
     * siren code of the collectivity to get the Id from
     */
    private String siren;

    @Override
    protected void validateInputParameters() throws SispeaException {

        // Check collectivity SIREN and exercise
        checkSiren();
        checkYear();
    }

    /**
     * Check the SIREN code parameter. If not set, throws an error
     */
    protected void checkSiren() throws SispeaException {

        if (siren == null || "".equals(siren)) {
            id = null;
        } else {
            // Retrieve ID from INSEE code
            OrganismDto o = referentialService.findOrganismBySirenCode(siren);
            id = o.getId().toString();
        }

        checkId();
    }


    /**
     * Check the Year parameter. If not set, set to current exercise.
     */
    protected void checkYear() throws SispeaException {
        if (annee == null || "".equals(annee)) {
            ExerciseDto e = exerciseService.getCurrentExercise();
            chosenExerciseId = e.getId();
            annee = e.getStrYear();
        } else {
            ExerciseDto exercise = exerciseService.getExerciseByYear(Short.valueOf(annee));
            chosenExerciseId = exercise.getId();
        }

        checkExercise();
    }

    public String getAnnee() {
        return annee;
    }

    public void setAnnee(String pAnnee) {
        annee = pAnnee;
    }

    public String getSiren() {
        return siren;
    }

    public void setSiren(String pSiren) {
        siren = pSiren;
    }

}
