package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.service.referential.OrganismType;
import fr.onema.sispea.service.referential.RPQSDto;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

import java.io.FileInputStream;
import java.io.InputStream;

/**
 * This action download a collectivity RPQS.
 *
 * @author CS
 */
public class DownloadRPQSAction extends AbstractCollectivityAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(DownloadRPQSAction.class);

    /**
     * RPQS id to download
     */
    protected Integer rpqsId;

    /**
     * The rpqs content/MIME type.
     */
    protected String rpqsContentType;

    /**
     * The rpqs file size.
     */
    protected Long rpqsSize;

    /**
     * The rpqs original filename.
     */
    protected String rpqsFileName;

    /**
     * The rpqs input stream.
     */
    protected transient InputStream inputStream;

    /**
     * Territory associated to current organism displayed.
     */
    protected TerritoryDto territory;

    @Override
    protected String doExecute() throws Exception {
        String result = SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("Download collectivity RPQS");
        }

        // Open menu according to the current JSP item.
        openMenu(MenuConstants.MENU_KEY_SEE_COLLECTIVITY);

        // check params
        checkId();
        checkExercise();

        // Try to get back the rpqs.
        RPQSDto lRpqs = referentialService.readRpqs(rpqsId);

        // no right check : data visible for everybody

        if (lRpqs == null) {
            //handle error
            addActionError(getText(COLLECTIVITY_PREFIX + "error.noRpqsIdToDownload"));
            result = ERROR;
        } else {
            // Update all RPQS fields.
            InputStream lInputStream = new FileInputStream(lRpqs.getFile());

            setRpqsSize(lRpqs.getFileSize());
            //"application/msword"); //"image/bmp");
            setRpqsContentType(lRpqs.getContentType());
            setRpqsFileName(lRpqs.getFilename());
            setInputStream(lInputStream); // FIXME AThimel 07/07/15 export.getFile() is not deleted after download
        }

        // reload collectivity
        collectivity = referentialService.readCollectivity(orgId, exercise, false);

        // load territory
        territory = territoryService.readTerritory(collectivity.getId(), OrganismType.Collectivity);

        // change menu ?
        openMenu(getProperMenuKey(territory));

        //result
        return result;
    }

    public Integer getRpqsId() {
        return rpqsId;
    }

    public void setRpqsId(Integer rpqsId) {
        this.rpqsId = rpqsId;
    }

    public InputStream getInputStream() {
        return inputStream;
    }

    public void setInputStream(InputStream pInputStream) {
        inputStream = pInputStream;
    }

    public String getRpqsContentType() {
        return rpqsContentType;
    }

    public void setRpqsContentType(String pRpqsContentType) {
        rpqsContentType = pRpqsContentType;
    }

    public String getRpqsFileName() {
        return rpqsFileName;
    }

    public void setRpqsFileName(String pRpqsFilename) {
        rpqsFileName = pRpqsFilename;
    }

    public Long getRpqsSize() {
        return rpqsSize;
    }

    public void setRpqsSize(Long pRpqsSize) {
        rpqsSize = pRpqsSize;
    }

    public TerritoryDto getTerritory() {
        return territory;
    }

    public void setTerritory(TerritoryDto territory) {
        this.territory = territory;
    }
}
