package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.service.referential.TerritoryDto;


/**
 * This action manages territory creation and removal.
 * These two functionalities are available for administrator users only, in the territory search web page.
 *
 * @author CS
 */
public class CreateTerritoryAction extends AbstractTerritoryAction {

    private static final long serialVersionUID = 1L;

    /**
     * ID of mixed territory to create.
     */
    protected String createdTerritoryId;

    @Override
    protected String doExecute() throws Exception {
        String lResult = SUCCESS;

        // check exercise
        checkExercise();

        // Add a new empty territory.
        Integer lCreatedID = territoryService.createTerritory(getText("fr.onema.sispea.common.newTerritoryName"));

        // Store the newly created territory ID.
        createdTerritoryId = lCreatedID.toString();

        // Set the territory into session.
        TerritoryDto lTerr = territoryService.readTerritory(lCreatedID);
        setTerritory(lTerr);

        // result
        return lResult;

    }

    public String getCreatedTerritoryId() {
        return createdTerritoryId;
    }

    public void setCreatedTerritoryId(String pCreatedTerritoryId) {
        createdTerritoryId = pCreatedTerritoryId;
    }

}
