package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.referential.SPEADto;
import fr.onema.sispea.service.user.UserDto;
import org.apache.log4j.Logger;

/**
 * This action redirects a collectivity user to:
 * <ul>
 * <li>the collectivity page if the collectivity has more than one SPEA.</li>
 * <li>the SPEA data page for the current exercise if the collectivity has only one SPEA.</li>
 * </ul>
 *
 * @author CS
 */
public class CollectivityUserRedirectAction extends AbstractCollectivityAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(CollectivityUserRedirectAction.class);

    @Override
    protected String doExecute() throws Exception {

        // Initialize the next page
        String nextPage = "welcome";

        // Initialize all action messages
        clearMessages();

        // Get the current user
        UserDto user = getCurrentUser();

        if (user.isCollectivity()) {

            // Get the current exercise
            if (exercise == null) {
                Integer exerciseId = exerciseService.getCurrentExerciseId();
                exercise = exerciseService.readExercise(exerciseId);
            }
            if (exercise == null) {
                throw new SispeaException(getText("fr.onema.sispea.jsp.fixRef.exerciseListAction.error.wrongExerciseId"));
            }

            // Get collectivity model instance.
            id = String.valueOf(user.getOrganismId().intValue());
            collectivity = referentialService.readCollectivity(user.getOrganismId(), exercise, false);

            nextPage = "collectivity";

            // Is there more than one SPEA
            if (collectivity.getSpeas().size() == 1) {

                // Go to the SPEA data page for the current exercise
                nextPage = "speaData";

                // Set the needed parameters
                SPEADto spea = collectivity.getSpeas().iterator().next();
                id = String.valueOf(spea.getId().intValue());
            }
        }

        if (logger.isDebugEnabled()) {
            logger.debug("Redirecting collectivity user -> " + nextPage);
        }

        return nextPage;
    }

}
