package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.common.PagingDto;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.search.BooleanCriterion;
import fr.onema.sispea.service.search.ConnectionType;
import fr.onema.sispea.service.search.OrderByFieldDto;
import fr.onema.sispea.service.search.OrderByFieldType;
import fr.onema.sispea.service.search.SearchFieldsDto;
import fr.onema.sispea.service.search.UserOrderByFieldPossibility;
import fr.onema.sispea.service.search.UsersFilterDto;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.service.user.UserType;
import fr.onema.sispea.service.user.UsersFormDto;
import fr.onema.sispea.struts.AbstractSispeaAction;
import fr.onema.sispea.util.constants.SispeaConstants;
import fr.onema.sispea.util.constants.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;


/**
 * This action is the base class for all referential cards with users actions.
 *
 * @author CS
 */
public abstract class AbstractUsersManagementAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

    protected PagingDto pagingUser = new PagingDto();

    protected UsersFormDto searchUsersInfo = new UsersFormDto();

    /**
     * Load users of a territory.
     *
     * @throws SispeaException
     */
    protected void loadUsers(TerritoryDto territory) throws SispeaException {

        // sort order
        SearchFieldsDto filter = new SearchFieldsDto();
        filter.getOrderByFields().add(new OrderByFieldDto(OrderByFieldType.ASC,
                                                          UserOrderByFieldPossibility.defaut.getTableAlias(),
                                                          UserOrderByFieldPossibility.defaut.getHqlFieldName(),
                                                          UserOrderByFieldPossibility.defaut.getSqlFieldName()));

        // Load all users associated to this territory
        List<UserDto> users = userService.readUsers(territory, false, false, 0, SispeaConstants.RETURN_ALL_RESULTS, filter);

        // set users
        territory.setUsers(users);

        // paging
        manageUserPaging(territory);

    }

    /**
     * manage territory users paging after territory loading.
     */
    protected void manageUserPaging(TerritoryDto territory) {

        // count
        int userCount = territory.getUsers().size();

        // set member result count
        pagingUser.setResultCount(userCount);

        // get start and end idx to extract
        Integer startIndex = pagingUser.getStartIndex() * pagingUser.getPageSize();
        Integer endIndex = startIndex + pagingUser.getPageSize();
        if (endIndex >= userCount) {
            endIndex = userCount;
        }

        List<UserDto> users = (List<UserDto>) territory.getSortedUsers();

        // make sub list
        List<UserDto> usersSubList = users.subList(startIndex, endIndex);

        // set sub list
        territory.setUsers(usersSubList);

        // set page offset
        pagingUser.setPageOffset(pagingUser.getStartIndex());

    }

    /**
     * check if search params shoud be in session
     */
    protected void checkSessionParams() {

        if (searchUsersInfo == null || !searchUsersInfo.isUseSession()) {
            // get session parameters
            getSispeaSession().setUsersSearchInfo(searchUsersInfo);
        } else {
            // should use session
            if (getSispeaSession().getUsersSearchInfo() == null) {
                getSispeaSession().setUsersSearchInfo(searchUsersInfo);
            }

            // change some params ?
            if (searchUsersInfo.isChangeSortOrder()) {
                // update session order params with request params
                getSispeaSession().getUsersSearchInfo().getFilter().setSortCriterionId(searchUsersInfo.getFilter().getSortCriterionId());
                getSispeaSession().getUsersSearchInfo().getFilter().setSortDirectionId(searchUsersInfo.getFilter().getSortDirectionId());
            }
            if (searchUsersInfo.isChangeGoToPage()) {
                getSispeaSession().getUsersSearchInfo().getPaging().setGoToPage(searchUsersInfo.getPaging().getGoToPage());
            }
        }

        // set session to local
        if (searchUsersInfo.isUseSession()) {
            searchUsersInfo = getSispeaSession().getUsersSearchInfo();
        }

    }

    /**
     * @param pStr
     * @return a formatted string for display only
     */
    public String formatString(String pStr) {
        //format
        String lRes = StringUtils.formatString(pStr);

        // result
        return lRes;
    }

    public Map<String, String> getUserTypes() {

        //init list
        Map<String, String> lRes = new TreeMap<>();

        // add empty line
        lRes.put(UsersFilterDto.NO_FILTER_ID.toString(), getText(UsersFilterDto.NO_FILTER_LABEL_KEY));

        // current user
        UserDto lUser = getCurrentUser();
        if (lUser != null) {
            // get the allowed user type for current user
            for (UserType lUserType : lUser.getType().getIncludedTypes()) {
                lRes.put(Integer.valueOf(lUserType.getId()).toString(), getText(lUserType.getLabelKey()));
            }
        }

        return lRes;
    }

    public Map<String, String> getAllUserTypes() {

        //init list
        Map<String, String> lRes = new TreeMap<>();

        // add empty line
        lRes.put(UsersFilterDto.NO_FILTER_ID.toString(), getText(UsersFilterDto.NO_FILTER_LABEL_KEY));

        // get the allowed user type for current user
        for (UserType lUserType : UserType.values()) {
            lRes.put(Integer.valueOf(lUserType.getId()).toString(), getText(lUserType.getLabelKey()));
        }

        return lRes;
    }

    public Map<String, String> getConnectionTypes() throws SispeaException {

        //init list
        Map<String, String> lRes = new TreeMap<>();

        // add empty line
        lRes.put(UsersFilterDto.NO_FILTER_ID.toString(), getText(UsersFilterDto.NO_FILTER_LABEL_KEY));

        for (int j = 0; j < ConnectionType.values().length; j++) {
            ConnectionType lConnectionType = ConnectionType.values()[j];
            lRes.put(Integer.valueOf(lConnectionType.getId()).toString(), getText(lConnectionType.getLabelKey()));
        }

        return lRes;
    }

    public Map<String, String> getBooleanCriteria() throws SispeaException {

        //init list
        Map<String, String> lRes = new TreeMap<>();

        // add empty line
        lRes.put(UsersFilterDto.NO_FILTER_ID.toString(), getText(UsersFilterDto.NO_FILTER_LABEL_KEY));

        for (int j = 0; j < BooleanCriterion.values().length; j++) {
            BooleanCriterion lBooleanCriterion = BooleanCriterion.values()[j];
            lRes.put(Integer.valueOf(lBooleanCriterion.getId()).toString(), getText(lBooleanCriterion.getLabelKey()));
        }

        return lRes;
    }

    public BooleanCriterion getTrueCriterion() {
        return BooleanCriterion.True;
    }

    public PagingDto getPagingUser() {
        return pagingUser;
    }

    public UsersFormDto getSearchUsersInfo() {
        return searchUsersInfo;
    }

    public void setSearchUsersInfo(UsersFormDto searchUsersInfo) {
        this.searchUsersInfo = searchUsersInfo;
    }
}
