package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.DataFloatValueDto;
import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.data.ExerciseService;
import fr.onema.sispea.service.data.SPEALotService;
import fr.onema.sispea.service.data.VPValueDto;
import fr.onema.sispea.service.referential.ReferentialService;
import fr.onema.sispea.service.referential.SPEADto;
import fr.onema.sispea.struts.AbstractSispeaAction;
import fr.onema.sispea.struts.referential.bean.XmlGroupTableDetail;
import fr.onema.sispea.struts.referential.bean.XmlGroupTableDetailValue;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * This abstract action is the basis for all actions used to manage SPEA indicators.
 *
 * @author CS
 */
public abstract class AbstractTaxesEditorAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

    @Autowired
    protected transient ExerciseService exerciseService;

    @Autowired
    protected transient SPEALotService speaLotService;

    @Autowired
    protected transient ReferentialService referentialService;

    /**
     * spea data editing mode (for back navigation)
     */
    protected String editingGroupId;

    /**
     * the sub detail data id
     */
    protected String subDetailId;

    /**
     * the detail type
     */
    protected Integer detailType;

    /**
     * the sub detail code
     */
    protected String code;

    /**
     * spea id to display
     */
    protected Integer speaId;

    /**
     * spea to display
     */
    protected SPEADto spea;

    /**
     * Exercise id to display
     */
    protected Integer exerciseId;

    /**
     * exercise to display
     */
    protected ExerciseDto exercise;

    /**
     * the group id detailed
     */
    protected String xmlGroupTableDetailContainingValueDetailedId;

    /**
     * The froup id to detail
     */
    protected String xmlGroupTableDetailToDetailId;

    /**
     * check exercise parameter
     *
     * @throws SispeaException
     */
    protected void checkExerciseParameter() throws SispeaException {

        if (exerciseId == null) {
            throw new SispeaException("fr.onema.sispea.referential.action.showSpeaIndicators.error.wrongExerciseId");
        }

        // check if exercise exists
        exercise = exerciseService.readExercise(exerciseId);
        if (exercise == null) {
            throw new SispeaException("fr.onema.sispea.referential.action.showSpeaIndicators.error.wrongExerciseId");
        }
    }

    /**
     * loads spea if exists, raise exception else
     *
     * @throws SispeaException
     */
    protected void loadSpea(ExerciseDto pExercise) throws SispeaException {
        spea = referentialService.readSPEA(speaId, pExercise, false);
        if (spea == null) {
            throw new SispeaException("fr.onema.sispea.referential.action.showSpeaIndicators.error.wrongSpeaId");
        }
    }

    /**
     * refresh values displayed reflecting recent changes
     */
    protected void reCompute(XmlGroupTableDetailValue pXmlGroupDetailed, XmlGroupTableDetail pXmlGroupToDetail) {

        // formula too compute :
        // - Assainissement :     ([217] + [218] + [219])         * 120 * (1 + [213]/100) + ([177] + [178]) * [213]/100
        // - eau potable :         ([214] + [215] + [216] + [219]) * 120 * (1 + [213]/100) + ([177] + [178]) * [213]/100


        // init
        Double lSum = 0.0;
        Double l213 = 0.0;
        Double l177Plus178 = 0.0;

        // get the values of 177 and 178
        for (XmlGroupTableDetailValue lXmlGroupTableDetailValue : getSispeaSession().getXmlCurrentContextGroup()) {
            DataFloatValueDto lValue = (DataFloatValueDto) lXmlGroupTableDetailValue.getValue();
            if (lValue != null && !lValue.isEmpty()) {
                l177Plus178 = l177Plus178 + lValue.getFloatValue();
            }
        }

        // get the value to update
        DataFloatValueDto lValueToUpdate = (DataFloatValueDto) pXmlGroupDetailed.getValue();

        // loop on detail values to get slice part sum
        for (XmlGroupTableDetailValue lXmlGroupTableDetailValue : pXmlGroupToDetail.getGroupTableDetailValues()) {
            // read value
            VPValueDto lValue = (VPValueDto) lXmlGroupTableDetailValue.getValue();
            if (!lValue.isEmpty()) {
                if (lValue.getVp().getGspId().intValue() == 213) {
                    l213 = lValue.getFloatValue();
                } else {
                    lSum = lSum + lValue.getFloatValue();
                }
            }
        }

        Double lResult = lSum * 120 * (1 + l213 / 100) + l177Plus178 * l213 / 100;
        ;

        // update price
        lValueToUpdate.setFloatValue(lResult);
    }

    // GETTERS AND SETTERS
    public String getSubDetailId() {
        return subDetailId;
    }

    public void setSubDetailId(String subDetailId) {
        subDetailId = subDetailId;
    }

    public Integer getSpeaId() {
        return speaId;
    }

    public void setSpeaId(Integer pSpeaId) {
        speaId = pSpeaId;
    }

    public Integer getExerciseId() {
        return exerciseId;
    }

    public void setExerciseId(Integer exerciseId) {
        exerciseId = exerciseId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String pCode) {
        code = pCode;
    }


    public ExerciseDto getExercise() {
        return exercise;
    }

    public void setExercise(ExerciseDto pExercise) {
        exercise = pExercise;
    }

    public SPEADto getSpea() {
        return spea;
    }

    public void setSpea(SPEADto pSpea) {
        spea = pSpea;
    }

    public String getEditingGroupId() {
        return editingGroupId;
    }

    public void setEditingGroupId(String pEditingGroupId) {
        editingGroupId = pEditingGroupId;
    }

    public String getXmlGroupTableDetailContainingValueDetailedId() {
        return xmlGroupTableDetailContainingValueDetailedId;
    }

    public void setXmlGroupTableDetailContainingValueDetailedId(
            String pXmlGroupTableDetailContainingValueDetailedId) {
        xmlGroupTableDetailContainingValueDetailedId = pXmlGroupTableDetailContainingValueDetailedId;
    }

    public String getXmlGroupTableDetailToDetailId() {
        return xmlGroupTableDetailToDetailId;
    }

    public void setXmlGroupTableDetailToDetailId(
            String pXmlGroupTableDetailToDetailId) {
        xmlGroupTableDetailToDetailId = pXmlGroupTableDetailToDetailId;
    }

    public XmlGroupTableDetailValue getXmlCurrentGroupDetailed() {
        return getSispeaSession().getXmlCurrentGroupDetailed();
    }

    public void setXmlCurrentGroupDetailed(XmlGroupTableDetailValue pXmlCurrentGroupDetailed) {
        getSispeaSession().setXmlCurrentGroupDetailed(pXmlCurrentGroupDetailed);
    }

    public XmlGroupTableDetail getXmlCurrentGroupToDetail() {
        return getSispeaSession().getXmlCurrentGroupToDetail();
    }

    public void setXmlCurrentGroupToDetail(XmlGroupTableDetail pXmlCurrentGroupToDetail) {
        getSispeaSession().setXmlCurrentGroupToDetail(pXmlCurrentGroupToDetail);
    }

    public List<XmlGroupTableDetailValue> getXmlCurrentContextGroup() {
        return getSispeaSession().getXmlCurrentContextGroup();
    }

}

