package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.common.PagingDto;
import fr.onema.sispea.service.referential.DDTDto;
import fr.onema.sispea.service.referential.EquipmentDto;
import fr.onema.sispea.service.referential.SPEADto;
import fr.onema.sispea.service.referential.SpeaMemberDto;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.user.MandateDto;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;

import java.util.ArrayList;
import java.util.List;

/**
 * This action is the base class for all the SPEA presentation actions..
 *
 * @author CS
 */
public abstract class AbstractSPEAPresentationAction extends AbstractReferentialCardAction {

    /**
     * Default Smaller paginantion page size
     */
    protected static final Integer DEFAULT_SMALLER_PAGE_SIZE = 10;

//    /**
//     * Internationalization prefix for SPEAPresentation GUI.
//     */
//    protected static final String SPEA_PREFIX = "fr.onema.sispea.jsp.fixRef.showSPEAPresentation.";

    private static final long serialVersionUID = 1L;

    /**
     * The paging information for members.
     */
    protected PagingDto pagingMember = new PagingDto();

    /**
     * The paging information for equipments.
     */
    protected PagingDto pagingEquipment = new PagingDto();

    /**
     * The paging information for mandates.
     */
    protected PagingDto pagingMandate = new PagingDto();

//    /**
//     * can edit ?
//     */
//    protected Boolean canEdit = null;

//    /**
//     * can check ?
//     */
//    protected boolean canCheck;

//    /**
//     * can view ?
//     */
//    protected Boolean canView = null;

//    /**
//     * can mandate ?
//     */
//    protected Boolean canViewMandate = null;

//    /**
//     * can mandate ?
//     */
//    protected boolean canMandate;

    /**
     * spea loaded
     */
    protected SPEADto spea= new SPEADto();

    /**
     * Spea's associated DDT
     */
    protected DDTDto ddt;

    /**
     * available users for mandates
     */
    protected List<UserDto> availableUsers;

    /**
     * users login to mandate on SPEA
     */
    protected List<String> usersToMandate = new ArrayList<>();

    /**
     * Mandate to process
     */
    protected MandateDto mandate;

//    public AbstractSPEAPresentationAction() {
//        spea = new SPEADto();
//    }

    /**
     * init paging sizes
     */
    protected void initPagingSizes() {

        if (pagingMandate != null) {
            pagingMandate.setPageSize(DEFAULT_SMALLER_PAGE_SIZE);
        }

    }

//    /**
//     * return true if current user can edit spea ref
//     *
//     * @return
//     */
//    public Boolean canEditSpea() throws SispeaException {
//        // check rights ont it
//        return checkUserRight(Right.Edit, getTerritory(), exercise);
//    }

//    /**
//     * return true if current user can check spea ref
//     *
//     * @return
//     */
//    public Boolean canCheckSpea() throws SispeaException {
//        // check rights ont it
//        return checkUserRight(Right.Check, getTerritory(), exercise);
//    }

//    /**
//     * return true if current user can view spea ref
//     *
//     * @return
//     */
//    public Boolean canViewSpea() throws SispeaException {
//        // check rights ont it
//        return checkUserRight(Right.View, getTerritory(), exercise);
//    }

    /**
     * manage member paging after spea load
     */
    protected void manageMemberPaging() {

        // set member result count
        pagingMember.setResultCount(spea.getMembers().size());

        // get start and end idx to extract
        Integer lStartIdx = pagingMember.getStartIndex() * pagingMember.getPageSize();
        Integer lEndIdx = lStartIdx + pagingMember.getPageSize();
        if (lEndIdx >= spea.getMembers().size()) {
            lEndIdx = spea.getMembers().size();
        }

        // make sub list
        List<SpeaMemberDto> lSubList = spea.getMembers().subList(lStartIdx, lEndIdx);
        // set sub list
        spea.setMembers(lSubList);

        // set page offset
        pagingMember.setPageOffset(pagingMember.getStartIndex());
    }

    /**
     * manage equipment paging after spea load
     */
    protected void manageEquipmentPaging() {
        // set member result count
        pagingEquipment.setResultCount(spea.getEquipments().size());

        // get start and end idx to extract
        Integer lStartIdx = pagingEquipment.getStartIndex() * pagingEquipment.getPageSize();
        Integer lEndIdx = lStartIdx + pagingEquipment.getPageSize();
        if (lEndIdx >= spea.getEquipments().size()) {
            lEndIdx = spea.getEquipments().size();
        }

        // make sub list
        List<EquipmentDto> lSubList = spea.getEquipments().subList(lStartIdx, lEndIdx);
        // set sub list
        spea.setEquipments(lSubList);

        // set page offset
        pagingEquipment.setPageOffset(pagingEquipment.getStartIndex());
    }

    /**
     * manage equipment paging after spea load
     */
    protected void manageMandatePaging() {
        // set member result count
        pagingMandate.setResultCount(getSpea().getMandates().size());

        // get start and end idx to extract
        Integer lStartIdx = pagingMandate.getStartIndex() * pagingMandate.getPageSize();
        Integer lEndIdx = lStartIdx + pagingMandate.getPageSize();
        if (lEndIdx >= getSpea().getMandates().size()) {
            lEndIdx = getSpea().getMandates().size();
        }

        // make sub list
        List<MandateDto> lSubList = getSpea().getMandates().subList(lStartIdx, lEndIdx);
        // set sub list
        spea.setMandates(lSubList);

        // set page offset
        pagingMandate.setPageOffset(pagingMandate.getStartIndex());
    }

//    /**
//     * return a formatted string for display only
//     *
//     * @param pStr
//     * @return
//     */
//    public String formatString(String pStr) {
//        //format
//        String lRes = StringUtils.formatString(pStr);
//
//        // result
//        return lRes;
//    }

//    @Override
//    protected TerritoryDto loadTerritory() throws SispeaException {
//        return territoryService.readTerritory(spea.getId(), OrganismType.SPEA);
//    }

    /**
     * @return true if page is mandating
     */
    public boolean isMandating() {

        boolean lRes = (submitValue != null &&
                        submitValue.equals(getText("fr.onema.sispea.jsp.fixRef.showSPEAPresentation.addmandateduser")))
                       || (isSearching());
        return lRes;

    }

    /**
     * @return true if searching
     */
    public boolean isSearching() {

        boolean lRes = (searchUsersInfo != null &&
                        searchUsersInfo.getFilter() != null &&
                        searchUsersInfo.getFilter().getSubmitValue() != null &&
                        searchUsersInfo.getFilter().getSubmitValue().equals(getText("fr.onema.sispea.jsp.fixRef.showSPEAPresentation.available.btnFilter")));
        return lRes;

    }

//    /**
//     * Finds a municipality from its Insee Code and return the name
//     *
//     * @param pInseeCode
//     * @return String
//     */
//    public String getEquipmentMunicipality(String pInseeCode) {
//        String lRes;
//
//        try {
//            MunicipalityDto lMunicipality = referentialService.findMunicipalityByInseeCode(pInseeCode);
//            if (lMunicipality != null && lMunicipality.getName() != null) {
//                lRes = lMunicipality.getName() + " (" + pInseeCode + ")";
//            } else {
//                throw new SispeaException("Municipality not found");
//            }
//        } catch (SispeaException e) {
//            lRes = pInseeCode;
//        }
//
//        return lRes;
//    }

    /**
     * @param territory
     * @param spea
     * @return menu key to open
     * @throws SispeaException
     */
    protected String getProperMenuKey(SPEADto spea, TerritoryDto territory) {
        // init result
        String lRes = MenuConstants.MENU_KEY_PRESENTATION;

        if (spea != null) {

            // check if spea is user's reference territory
            Integer lSpeaTerritoryId = getAssociatedTerritoryId(territory);
            Integer lUserTerritoryId = null;
            if (getCurrentUserTerritory() != null) {
                lUserTerritoryId = getCurrentUserTerritory().getId();
            }
            if (lSpeaTerritoryId.equals(lUserTerritoryId)) {
                // Open menu according to the current JSP item.
                lRes = MenuConstants.MENU_KEY_MYTERRITORIES;
            }
        }

        // result
        return lRes;
    }

    public String getDataDownloadFormatCSV() {
        return getText("fr.onema.sispea.exchange.download.file.formatCSV");
    }

    public String getDataDownloadFormatXML() {
        return getText("fr.onema.sispea.exchange.download.file.formatXML");
    }

    public SPEADto getSpea() {
        return spea;
    }

    public void setSpea(SPEADto pSpea) {
        spea = pSpea;
    }

//    /**
//     * @return true if spea can be edited
//     */
//    public Boolean getCanEdit() {
//        try {
//            if (canEdit == null) {
//                canEdit = canEditSpea();
//            }
//        } catch (SispeaException ex) {
//            canEdit = false;
//        }
//        return canEdit;
//    }
//
//    public void setCanEdit(Boolean pCanEdit) {
//        canEdit = pCanEdit;
//    }

//    /**
//     * @return true if user can check SPEA
//     */
//    public Boolean getCanCheck() {
//        try {
//            if (canCheck == null) {
//                canCheck = canCheckSpea();
//            }
//        } catch (SispeaException ex) {
//            canCheck = false;
//        }
//        return canCheck;
//    }
//
//    public void setCanCheck(Boolean pCanCheck) {
//        canCheck = pCanCheck;
//    }

//    /**
//     * @return true if spea can be viewed
//     */
//    public Boolean getCanView() {
//        try {
//            if (canView == null) {
//                canView = canViewSpea();
//            }
//        } catch (SispeaException ex) {
//            canView = false;
//        }
//        return canView;
//    }
//
//    public void setCanView(Boolean pCanView) {
//        canView = pCanView;
//    }

//    /**
//     * @return true if mandate can be viewed
//     */
//    public Boolean getCanViewMandate() {
//        try {
//            if (canViewMandate == null) {
//                canViewMandate = canViewMandateSpea();
//            }
//        } catch (SispeaException ex) {
//            canViewMandate = false;
//        }
//        return canViewMandate;
//    }

//    public void setCanViewMandate(Boolean pCanViewMandate) {
//        canViewMandate = pCanViewMandate;
//    }

//    /**
//     * @return true if user can mandate a spea
//     */
//    public Boolean getCanMandate() {
//        try {
//            if (canMandate == null) {
//                canMandate = canMandateSpea();
//            }
//        } catch (SispeaException ex) {
//            canMandate = false;
//        }
//        return canMandate;
//    }
//
//    public void setCanMandate(Boolean pCanMandate) {
//        canMandate = pCanMandate;
//    }

    public String getSpeaId() {
        return id;
    }

    public void setSpeaId(String pSpeaId) {
        id = pSpeaId;
    }

    public PagingDto getPagingMember() {
        return pagingMember;
    }

    public PagingDto getPagingEquipment() {
        return pagingEquipment;
    }

    public PagingDto getPagingMandate() {
        return pagingMandate;
    }

    public List<UserDto> getAvailableUsers() {
        return availableUsers;
    }

    public void setAvailableUsers(List<UserDto> pAvailableUsers) {
        availableUsers = pAvailableUsers;
    }

    public List<String> getUsersToMandate() {
        return usersToMandate;
    }

    public void setUsersToMandate(List<String> pUsersToMandate) {
        usersToMandate = pUsersToMandate;
    }

    public Integer getExerciseId() {
        return chosenExerciseId;
    }

    public void setExerciseId(Integer pExerciseId) {
        chosenExerciseId = pExerciseId;
    }

    public DDTDto getDdt() {
        return ddt;
    }

    public void setDdt(DDTDto pDdt) {
        ddt = pDdt;
    }

}
