package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.DataDetailValueDto;
import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.data.ExerciseService;
import fr.onema.sispea.service.data.SPEALotService;
import fr.onema.sispea.service.data.VPValueDto;
import fr.onema.sispea.service.referential.ReferentialService;
import fr.onema.sispea.service.referential.SPEADto;
import fr.onema.sispea.service.user.PasswordService;
import fr.onema.sispea.struts.AbstractSispeaAction;
import fr.onema.sispea.struts.referential.bean.XmlGroupTableDetail;
import fr.onema.sispea.struts.referential.bean.XmlGroupTableDetailValue;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.Iterator;

/**
 * This abstract action is the basis for all actions used to manage SPEA indicators.
 *
 * @author CS
 */
public abstract class AbstractPriceEditorAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

    @Autowired
    protected transient ExerciseService exerciseService;

    @Autowired
    protected transient SPEALotService speaLotService;

    @Autowired
    protected transient ReferentialService referentialService;

    @Autowired
    protected transient PasswordService passwordService;

    /**
     * spea dataz editing mode (for back navigation)
     */
    protected String editingGroupId;

    /**
     * the group id detailed
     */
    protected String xmlGroupTableDetailContainingValueDetailedId;

    /**
     * The froup id to detail
     */
    protected String xmlGroupTableDetailToDetailId;

    /**
     * the sub detail code
     */
    protected String code;

    /**
     * spea id to display
     */
    protected Integer speaId;

    /**
     * spea to display
     */
    protected SPEADto spea;

    /**
     * Exercise id to display
     */
    protected Integer exerciseId;

    /**
     * exercise to display
     */
    protected ExerciseDto exercise;

    /**
     * the detail type : 0 if delegatee, 1 if collectivity
     */
    protected Integer detailType;

    /**
     * the value into bounds
     */
    protected String boundValue = "0.0";

    /**
     * the value of upper bound
     */
    protected String upperBound = "0";

    /**
     * the value of upper bound
     */
    protected Long lowerBound = (long) 0;

    /**
     * general comment on lot
     */
    protected String generalComment;

    /**
     * the slice to process
     */
    protected String sliceId;

    /**
     * check exercise parameter
     *
     * @throws SispeaException
     */
    protected void checkExerciseParameter() throws SispeaException {

        if (exerciseId == null) {
            throw new SispeaException("fr.onema.sispea.referential.action.showSpeaIndicators.error.wrongExerciseId");
        }

        // check if exercise exists
        exercise = exerciseService.readExercise(exerciseId);
        if (exercise == null) {
            throw new SispeaException("fr.onema.sispea.referential.action.showSpeaIndicators.error.wrongExerciseId");
        }
    }

    /**
     * loads spea if exists, raise exception else
     *
     * @throws SispeaException
     */
    protected void loadSpea(ExerciseDto pExercise) throws SispeaException {
        spea = referentialService.readSPEA(speaId, pExercise, false);
        if (spea == null) {
            throw new SispeaException("fr.onema.sispea.referential.action.showSpeaIndicators.error.wrongSpeaId");
        }
    }

    /**
     * remove selected slice from sispea session
     *
     * @param pXmlGroupTableDetail
     * @throws SispeaException
     */
    protected void removeSliceFromCurrentDisplayGroup(XmlGroupTableDetail pXmlGroupTableDetail, String pXmlGroupDetailValueIdToDelete) throws SispeaException {

        // check slices count
        if (pXmlGroupTableDetail.getGroupTableDetailValues() == null || pXmlGroupTableDetail.getGroupTableDetailValues().size() < 1) {
            throw new SispeaException("fr.onema.sispea.dataDetail.jsp.showPriceEditor.error.removeLastSlice");
        }

        // loop on detail to find value to delete
        DataDetailValueDto lValue = null;
        for (Iterator<XmlGroupTableDetailValue> iterator = pXmlGroupTableDetail.getGroupTableDetailValues().iterator(); iterator.hasNext() && lValue == null; ) {
            XmlGroupTableDetailValue lXmlGroupTableDetailValue = iterator.next();

            // found ?
            if (lXmlGroupTableDetailValue.getId() != null
                && lXmlGroupTableDetailValue.getId().equals(pXmlGroupDetailValueIdToDelete)) {

                // found !
                lValue = (DataDetailValueDto) lXmlGroupTableDetailValue.getValue();

                // check bounds
                if (lValue.getUpperBound().intValue() == DataDetailValueDto.DEFAULT_UPPER_BOUND) {
                    throw new SispeaException(getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.addSlice.error.deleteBound"));
                }

                // remove
                iterator.remove();
            }
        }

        // refresh bounds
        refreshBounds(pXmlGroupTableDetail);

    }

    /**
     * refresh upper and lower bound value
     */
    protected void refreshBounds(XmlGroupTableDetail pXmlGroupTableDetail) {

        // sort slices
        Collections.sort(pXmlGroupTableDetail.getGroupTableDetailValues());

        // loop
        Long lLowerBound = (long) 0;
        for (XmlGroupTableDetailValue lXmlGroupTableDetailValue : pXmlGroupTableDetail.getGroupTableDetailValues()) {
            // slice ?
            if (lXmlGroupTableDetailValue.isSliceValue()) {
                DataDetailValueDto lValue = (DataDetailValueDto) lXmlGroupTableDetailValue.getValue();

                // update bounds
                lValue.setLowerBound(lLowerBound);
                lLowerBound = lValue.getUpperBound();

                // update name
                lXmlGroupTableDetailValue.setName(getText("fr.onema.sispea.dataDetail.collectivity.slice.read",
                                                          "", new String[]{lValue.getLowerBound().toString(), lValue.getUpperBound().toString()}));
            }
        }
    }

    public String getXmlGroupTableDetailContainingValueDetailedId() {
        return xmlGroupTableDetailContainingValueDetailedId;
    }

    public void setXmlGroupTableDetailContainingValueDetailedId(
            String pXmlGroupTableDetailContainingValueDetailedId) {
        xmlGroupTableDetailContainingValueDetailedId = pXmlGroupTableDetailContainingValueDetailedId;
    }

    public String getXmlGroupTableDetailToDetailId() {
        return xmlGroupTableDetailToDetailId;
    }

    public void setXmlGroupTableDetailToDetailId(
            String pXmlGroupTableDetailToDetailId) {
        xmlGroupTableDetailToDetailId = pXmlGroupTableDetailToDetailId;
    }

    public Integer getSpeaId() {
        return speaId;
    }

    public void setSpeaId(Integer pSpeaId) {
        speaId = pSpeaId;
    }

    public Integer getExerciseId() {
        return exerciseId;
    }

    public void setExerciseId(Integer exerciseId) {
        exerciseId = exerciseId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String pCode) {
        code = pCode;
    }

    public ExerciseDto getExercise() {
        return exercise;
    }

    public void setExercise(ExerciseDto pExercise) {
        exercise = pExercise;
    }

    public SPEADto getSpea() {
        return spea;
    }

    public void setSpea(SPEADto pSpea) {
        spea = pSpea;
    }

    public XmlGroupTableDetailValue getXmlCurrentGroupDetailed() {
        return getSispeaSession().getXmlCurrentGroupDetailed();
    }

    public void setXmlCurrentGroupDetailed(XmlGroupTableDetailValue pXmlCurrentGroupDetailed) {
        getSispeaSession().setXmlCurrentGroupDetailed(pXmlCurrentGroupDetailed);
    }

    public XmlGroupTableDetail getXmlCurrentGroupToDetail() {
        return getSispeaSession().getXmlCurrentGroupToDetail();
    }

    public void setXmlCurrentGroupToDetail(XmlGroupTableDetail pXmlCurrentGroupToDetail) {
        getSispeaSession().setXmlCurrentGroupToDetail(pXmlCurrentGroupToDetail);
    }

    public Integer getDetailType() {
        return detailType;
    }

    public void setDetailType(Integer pDetailType) {
        detailType = pDetailType;
    }

    public String getBoundValue() {
        return boundValue;
    }

    public void setBoundValue(String pBoundValue) {
        boundValue = pBoundValue;
    }

    public String getUpperBound() {
        return upperBound;
    }

    public void setUpperBound(String pUpperBound) {
        upperBound = pUpperBound;
    }

    public Long getLowerBound() {
        return lowerBound;
    }

    public void setLowerBound(Long pLowerBound) {
        lowerBound = pLowerBound;
    }

    public String getGeneralComment() {
        return generalComment;
    }

    public void setGeneralComment(String pGeneralComment) {
        generalComment = pGeneralComment;
    }

    public String getEditingGroupId() {
        return editingGroupId;
    }

    public void setEditingGroupId(String pEditingGroupId) {
        editingGroupId = pEditingGroupId;
    }

    public String getSliceId() {
        return sliceId;
    }

    public void setSliceId(String pSliceId) {
        sliceId = pSliceId;
    }

    public boolean isDelegateePriceDetail() {
        // init
        boolean lRes = false;

        // true if group detailed is Vp value of VP 177
        XmlGroupTableDetailValue lGroup = getXmlCurrentGroupDetailed();
        if (lGroup != null && lGroup.getValue() != null) {
            VPValueDto lValue = (VPValueDto) lGroup.getValue();
            lRes = (lValue.getVp().getGspId().intValue() == 177);
        }

        // result
        return lRes;
    }
}

