package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.service.referential.CollectivityDto;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;

/**
 * This abstract action is the basis for all actions used to manage collectivity presentation.
 *
 * @author CS
 */
public abstract class AbstractCollectivityAction extends AbstractReferentialCardAction {

    protected static final String RPQS_DOWNLOAD_URL = "downloadRPQSAction.action";

    /**
     * Internationalization prefix for collectivity presentation GUI.
     */
    protected static final String COLLECTIVITY_PREFIX = "fr.onema.sispea.jsp.fixRef.showCollectivity.";

//    private static final String RPQS_DOWNLOAD_URL = "downloadRPQSAction.action";
//
//    private static final Logger logger = Logger.getLogger(CollectivityAction.class);

//    /**
//     * The paging information for members.
//     */
//    protected PagingDto pagingMember = new PagingDto();
//
//    /**
//     * The paging information for services.
//     */
//    protected PagingDto pagingService = new PagingDto();
//
//    /**
//     * The paging information for transfered spea.
//     */
//    protected PagingDto pagingTransfered = new PagingDto();
//
//    /**
//     * The mandate paging information.
//     */
//    protected PagingDto mandatePaging = new PagingDto();

//    @Autowired
//    protected transient FileExchangeService fileExchangeService;

    private static final long serialVersionUID = 1L;

//    /**
//     * Flag to know if RPQS Publication is currently modified.
//     */
//    protected Boolean modifPublication = false;

//    /**
//     * The rpqs file.
//     */
//    protected File rpqs = null;
//
//    /**
//     * The rpqs link.
//     */
//    protected String rpqsLink = null;
//
//    /**
//     * The rpqs link.
//     */
//    protected String rpqsName = null;
//
//    /**
//     * The rpqs type.
//     */
//    protected String rpqsType = null;

//    /**
//     * The rpqs content/MIME type.
//     */
//    protected String rpqsContentType = null;
//
//    /**
//     * The rpqs file size.
//     */
//    protected Long rpqsSize = null;
//
//    /**
//     * The rpqs original filename.
//     */
//    protected String rpqsFileName = null;
//
//    /**
//     * The rpqs input stream.
//     */
//    protected InputStream inputStream = null;

//    /**
//     * The list of spea whose competence is transfered to
//     */
//    protected List<SPEATransferedDto> transferedSpeas = null;

//    /**
//     * The list of mandates concerning all services of the collectivity.
//     */
//    protected List<MandateDto> mandates = null;

    /**
     * Collectivity.
     */
    protected CollectivityDto collectivity;

    /**
     * Input parameter.
     * Set to true to modify the collectivity comment and link.
     */
    protected boolean edit;

//    /**
//     * Input parameter.
//     * Set to true to generate the RPQS for the collectivity.
//     */
//    protected Boolean generateRpqs = null;

//    /**
//     * true if current user can view this territory's mandates
//     */
//    protected boolean canViewMandates;

//    /**
//     * Territory associated to current organism displayed.
//     */
//    protected TerritoryDto territory;

//    public CollectivityAction() {
//        super();
//        mandates = new ArrayList<>();
//
//        // The paging beans are set by the spring context.
//    }

//    protected void manageViewActions() throws SispeaException {
//
//        try {
//
//            // Initialize the session
//            initSession();
//
//            if (orgId == null) {
//                throw new SispeaException(getText("fr.onema.sispea.jsp.fixRef.showCollectivity.error.noCollectivityId"));
//            }
//
//            // Get collectivity model instance.
//            collectivity = referentialService.readCollectivity(orgId, exercise, false);
//
//            if (collectivity == null) {
//                throw new SispeaException(getText("fr.onema.sispea.jsp.fixRef.showCollectivity.error.noCollectivity", "", orgId.toString()));
//            }
//
//            // load territory
//            territory = territoryService.readTerritory(collectivity.getId(), OrganismType.Collectivity);
//
//            // Compute the view access right to the SPEA lots of the exercise exercise_
//            for (SPEADto spea : collectivity.getSpeas()) {
//                boolean hasViewAccess = hasViewAccess(spea, exercise);
//                spea.setHasViewAccess(hasViewAccess);
//            }
//
//            // Load associated users.
//            loadUsers(territory);
//
//            // load transfered speas
//            // If it is the first page, then get the number of results too
//            if (pagingTransfered.getPageOffset() == PagingDto.FIRST_PAGE - 1) {
//                int resultCount = referentialService.countTransferedSpeas(collectivity,
//                                                                          exercise,
//                                                                          collectivity.getCollType() == CollectivityType.Municipality);
//                pagingTransfered.setResultCount(resultCount);
//                if (logger.isDebugEnabled()) {
//                    logger.debug(resultCount + " transfered spea(s) found");
//                }
//            }
//            transferedSpeas = referentialService.readTransferedSpeas(collectivity,
//                                                                     exercise,
//                                                                     collectivity.getCollType() == CollectivityType.Municipality,
//                                                                     pagingTransfered.getStartIndex() * pagingTransfered.getPageSize(),
//                                                                     pagingTransfered.getPageSize());
//            pagingTransfered.setPageOffset(pagingTransfered.getStartIndex());
//
//            // Compute the view access right to the transfered SPEA lots of the exercise exercise_
//            for (SPEATransferedDto transferedSpea : transferedSpeas) {
//                boolean hasViewAccess = hasViewAccess(transferedSpea.getSpea(), exercise);
//                transferedSpea.getSpea().setHasViewAccess(hasViewAccess);
//            }
//
//            // Do we need to load the mandates?
//            canViewMandates = computeCanViewMandates(getCurrentUser(), territory);
//            if (canViewMandates) {
//
//                // Load all mandates
//                // Loop through the speas
//                mandates.clear();
//                for (SPEADto spea : collectivity.getSpeas()) {
//
//                    // Do not ask the service to do the paging
//                    spea.setMandates(userService.readSpeaMandates(spea.getId()));
//                    mandates.addAll(spea.getMandates());
//                }
//                // Page the mandates
//                manageMandatePaging();
//            }
//
//            // Change menu ?
//            try {
//                openMenu(getProperMenuKey(territory));
//            } catch (Exception e) {
//                throw new SispeaException(e);
//            }
//
//            // Paging
//            manageMemberPaging();
//            manageServicePaging();
//            manageTransferedPaging();
//
//            // Do we need to generate the RPQS
//            if (Boolean.TRUE.equals(generateRpqs)) {
//
//                // Generate the RPQS
//                generateRpqs(getCurrentUser(), collectivity, exercise);
//
//                // Set the action message
//                addActionMessage(getText("fr.onema.sispea.jsp.fixRef.showCollectivity.rpqs.generating"));
//            }
//
//        } catch (SispeaException e) {
//            String lMessage = e.getMessage();
//            addActionError(getText("fr.onema.sispea.jsp.fixRef.showCollectivity.error.main", "", lMessage));
//            throw new SispeaException();
//        }
//
//    }

//    /**
//     * manage equipment paging after spea load
//     */
//    protected void manageMandatePaging() {
//
//        // set mandate result count
//        mandatePaging.setResultCount(mandates.size());
//
//        // Get the start and end indexes to extract
//        Integer startIndex = mandatePaging.getStartIndex() * mandatePaging.getPageSize();
//        Integer endIndex = startIndex + mandatePaging.getPageSize();
//        if (endIndex >= mandates.size()) {
//            endIndex = mandates.size();
//        }
//
//        // Make sub list
//        List<MandateDto> lSubList = mandates.subList(startIndex, endIndex);
//
//        // set sub list
//        mandates = lSubList;
//
//        // set page offset
//        mandatePaging.setPageOffset(mandatePaging.getStartIndex());
//    }

//    /**
//     * @param pUserLogin The login to test
//     * @return true if user's login is in mandated list
//     */
//    public boolean isUserMandated(String pUserLogin) {
//        boolean isUserMandated = false;
//
//        if (pUserLogin != null) {
//            // Loop through the mandates
//            for (Iterator<MandateDto> mandateIter = mandates.iterator(); mandateIter.hasNext() && !isUserMandated; ) {
//                MandateDto mandate = mandateIter.next();
//                if (pUserLogin.equals(mandate.getMandated().getLogin())) {
//                    isUserMandated = true;
//                }
//            }
//        }
//        return isUserMandated;
//    }

//    /**
//     * This method generates the RPQS for the SPEA.
//     *
//     * @param pCurrentUser
//     * @param pOrganism
//     * @param pExercise
//     * @throws SispeaException
//     */
//    protected void generateRpqs(UserDto pCurrentUser, OrganismDto pOrganism, ExerciseDto pExercise) throws SispeaException {
//
//        String territoryName = null;
//        try {
//            // Prepare the export parameters.
//            //
//            // The export is run with the SPEA territory
//            TerritoryDto territory = territoryService.readTerritory(pOrganism);
//            territoryName = territory.getName();
//
//            // For huge territories, cut it in smaller ones
//            List<TerritoryDto> territories = territoryService.buildExtractTerritoryList(territory, pExercise.getId(), pCurrentUser.getId());
//
//            // View right
//            Boolean hasViewRight = userService.checkUserRight(pCurrentUser, Right.View, territory, exercise);
//
//            ExportParameters parameters = new ExportParameters();
//            parameters.setUser(pCurrentUser);
//            parameters.setTerritories(territories);
//            parameters.setLang(getLocale().getLanguage());
//            parameters.setHasViewRight(hasViewRight);
//            parameters.setFileType(FileType.RPQS);
//            parameters.setWithData(false);
//            parameters.setWithReferential(false);
//            parameters.setExtractTerritoryName(territoryName);
//            parameters.setFileNamePrefix("RPQS_");
//            parameters.setFileNameDateFormat("yyyyMMdd_HHmmss");
//            parameters.setExercise(pExercise);
//            // Do not set any competences. They are not needed to generate the RPQS.
//            parameters.setCompetences(null);
//
//            // Generate the export
//            fileExchangeService.download(parameters);
//        } catch (Exception e) {
//            String msg = "Error while generating RPQS for the territory '" + territoryName + "'";
//            logger.error(msg, e);
//            throw new SispeaException(getText("fr.onema.sispea.jsp.fixRef.showCollectivity.rpqs.error", pOrganism.getName()));
//        }
//    }


//    /**
//     * manage member paging after Collectivity loading.
//     */
//    protected void manageMemberPaging() {
//
//        int lCount = collectivity.getCollectivityMembership().getMembers().size();
//
//        // set member result count
//        pagingMember.setResultCount(lCount);
//
//        // get start and end idx to extract
//        Integer lStartIdx = pagingMember.getStartIndex() * pagingMember.getPageSize();
//        Integer lEndIdx = lStartIdx + pagingMember.getPageSize();
//        if (lEndIdx >= lCount) {
//            lEndIdx = lCount;
//        }
//
//        ArrayList<CollectivityMemberDto> lMembers = (ArrayList<CollectivityMemberDto>) collectivity.getCollectivityMembership().getMembers();
//
//        // make sub list
//        List<CollectivityMemberDto> lSubList = lMembers.subList(lStartIdx, lEndIdx);
//
//        // set sub list
//        collectivity.getCollectivityMembership().setMembers(lSubList);
//
//        // set page offset
//        pagingMember.setPageOffset(pagingMember.getStartIndex());
//    }

//    /**
//     * manage services (SPEA) paging after Collectivity loading.
//     */
//    protected void manageServicePaging() {
//
//        int lCount = collectivity.getSpeas().size();
//
//        // set member result count
//        pagingService.setResultCount(lCount);
//
//        // get start and end idx to extract
//        Integer lStartIdx = pagingService.getStartIndex() * pagingService.getPageSize();
//        Integer lEndIdx = lStartIdx + pagingService.getPageSize();
//        if (lEndIdx >= lCount) {
//            lEndIdx = lCount;
//        }
//
//        ArrayList<SPEADto> lMembers = (ArrayList<SPEADto>) collectivity.getSpeas();
//
//        // make sub list
//        List<SPEADto> lSubList = lMembers.subList(lStartIdx, lEndIdx);
//
//        // set sub list
//        collectivity.setSpeas(lSubList);
//
//        // set page offset
//        pagingService.setPageOffset(pagingService.getStartIndex());
//    }

//    /**
//     * manage transfered spea paging after collectivity loading.
//     *
//     * @throws SispeaException
//     */
//    protected void manageTransferedPaging() throws SispeaException {
//
//
//    }

//    /**
//     * @return true if should be displayed, false else
//     */
//    public Boolean showHelp() {
//        // inint result
//        Boolean lRes = false;
//        try {
//            // check if territory is on user's territory
//            TerritoryDto lTerritory = getCurrentUserTerritory();
//            if (lTerritory != null) {
//                // collectivity territory
//                TerritoryDto lCollecTerritory = territoryService.readTerritory(collectivity.getId(), OrganismType.Collectivity);
//                // check inclusion
//                lRes = territoryService.checkInclusion(lTerritory, lCollecTerritory, chosenExerciseId);
//            }
//        } catch (SispeaException e) {
//            lRes = false;
//        }
//
//        // result
//        return lRes;
//    }

//    /**
//     * This method test if the user has publishing rights on this collectivity.
//     * If the user's territory equals the currently displayed collectivity's territory, then, user has RPQS publication rights.
//     *
//     * @return true if user has RPQS publication rights, false otherwise.
//     * @throws SispeaException
//     */
//    public Boolean userHasRights() throws SispeaException {
//
//        // init
//        Boolean lRights = false;
//
//        // check rights
//        if (collectivity != null) {
//
//            // get collectivity territory
//            TerritoryDto lCollectivityTerritory = getTerritory();
//
//            // check rigth
//            if (lCollectivityTerritory != null) {
//                lRights = checkUserRight(Right.Edit, lCollectivityTerritory, exercise);
//            }
//        }
//
//        return lRights;
//    }


//    /**
//     * This method test if the user has checking rights on this collectivity.
//     * If the user's territory equals the currently displayed collectivity's territory, then, user has RPQS publication rights.
//     *
//     * @return true if user has RPQS publication rights, false otherwise.
//     * @throws SispeaException
//     */
//    public Boolean userHasCheckRights() throws SispeaException {
//
//        // init
//        Boolean lRights = false;
//
//        // check rights
//        if (collectivity != null) {
//
//            // get collectivity territory
//            TerritoryDto lCollectivityTerritory = getTerritory();
//
//            // check rigth
//            if (lCollectivityTerritory != null) {
//                lRights = checkUserRight(Right.Check, lCollectivityTerritory, exercise);
//            }
//        }
//
//        return lRights;
//    }

//    /**
//     * This method test if the user has mandate rights on this collectivity.
//     * If the user's territory equals the currently displayed collectivity's territory, then, user has RPQS publication rights.
//     *
//     * @return true if user has RPQS publication rights, false otherwise.
//     * @throws SispeaException
//     */
//    public Boolean userHasMandateRights() throws SispeaException {
//
//        // init
//        Boolean lRights = false;
//
//        // check rights
//        if (collectivity != null) {
//
//            // get collectivity territory
//            TerritoryDto lCollectivityTerritory = getTerritory();
//
//            // check if this user has a mandate on one of the spea of this collectivity
//            UserDto lUser = getCurrentUser();
//            int lMandatesCount = userService.countMandatesWhereMandatedOnCollectivity(lUser, lCollectivityTerritory, exercise);
//
//            // mandates ?
//            if (lMandatesCount > 0) {
//                lRights = true;
//            }
//
//        }
//
//        return lRights;
//    }


    /**
     * @param territory
     * @return menu key to open
     */
    protected String getProperMenuKey(TerritoryDto territory) {
        // init result
        String lRes = MenuConstants.MENU_KEY_SEE_COLLECTIVITY;

        // check if collectivity is user's reference territory
        Integer lCollectTerritoryId = -1;
        if (territory != null) {
            lCollectTerritoryId = territory.getId();
        }
        Integer lUserTerritoryId = null;
        if (getCurrentUserTerritory() != null) {
            lUserTerritoryId = getCurrentUserTerritory().getId();
        }
        if (lCollectTerritoryId.equals(lUserTerritoryId)) {
            // Open menu according to the current JSP item.
            lRes = MenuConstants.MENU_KEY_MYTERRITORIES;
        }

        // result
        return lRes;
    }

//    @Override
//    protected TerritoryDto loadTerritory() throws SispeaException {
//        return territoryService.readTerritory(collectivity.getId(), OrganismType.Collectivity);
//    }

    public CollectivityDto getCollectivity() {
        return collectivity;
    }

    public void setCollectivity(CollectivityDto pCollectivity) {
        collectivity = pCollectivity;
    }

//    public Boolean getModifPublication() {
//        return modifPublication;
//    }
//
//    public void setModifPublication(Boolean pModifPublication) {
//        modifPublication = pModifPublication;
//    }

//    public File getRpqs() {
//        return rpqs;
//    }
//
//    public void setRpqs(File pRpqs) {
//        rpqs = pRpqs;
//    }
//
//    public String getRpqsType() {
//        return rpqsType;
//    }
//
//    public void setRpqsType(String pRpqsType) {
//        rpqsType = pRpqsType;
//    }
//
//    public String getRpqsLink() {
//        return rpqsLink;
//    }
//
//    public void setRpqsLink(String pRpqsLink) {
//        rpqsLink = pRpqsLink;
//    }

//    public String getRpqsContentType() {
//        return rpqsContentType;
//    }
//
//    public void setRpqsContentType(String pRpqsContentType) {
//        rpqsContentType = pRpqsContentType;
//    }
//
//    public String getRpqsFileName() {
//        return rpqsFileName;
//    }
//
//    public void setRpqsFileName(String pRpqsFilename) {
//        rpqsFileName = pRpqsFilename;
//    }
//
//    public Long getRpqsSize() {
//        return rpqsSize;
//    }
//
//    public void setRpqsSize(Long pRpqsSize) {
//        rpqsSize = pRpqsSize;
//    }

//    public InputStream getInputStream() {
//        return inputStream;
//    }
//
//    public void setInputStream(InputStream pInputStream) {
//        inputStream = pInputStream;
//    }

//    public String getRpqsModelUrl() {
//        return getText("fr.onema.sispea.jsp.fixRef.showCollectivity.RPQSModelUrl");
//    }

//    public String getDdtFormUrl() {
//        return getText("fr.onema.sispea.jsp.fixRef.showCollectivity.DDTFormUrl");
//    }

//    public PagingDto getPagingMember() {
//        return pagingMember;
//    }
//
//    public PagingDto getPagingService() {
//        return pagingService;
//    }
//
//    public PagingDto getPagingTransfered() {
//        return pagingTransfered;
//    }

//    public String getDataDownloadFormatCSV() {
//        return getText("fr.onema.sispea.exchange.download.file.formatCSV");
//    }
//
//    public String getDataDownloadFormatXML() {
//        return getText("fr.onema.sispea.exchange.download.file.formatXML");
//    }

//    public List<SPEATransferedDto> getTransferedSpeas() {
//        return transferedSpeas;
//    }
//
//    public void setTransferedSpeas(List<SPEATransferedDto> pTransferedSpeas) {
//        transferedSpeas = pTransferedSpeas;
//    }

//    public String getRpqsName() {
//        return rpqsName;
//    }
//
//    public void setRpqsName(String pRpqsName) {
//        rpqsName = pRpqsName;
//    }

    public boolean isEdit() {
        return edit;
    }

    public void setEdit(boolean pEdit) {
        edit = pEdit;
    }

//    public boolean getGenerateRpqs() {
//        return generateRpqs;
//    }
//
//    public void setGenerateRpqs(boolean pRpqs) {
//        generateRpqs = pRpqs;
//    }

//    public PagingDto getMandatePaging() {
//        return mandatePaging;
//    }

//    public List<MandateDto> getMandates() {
//        return mandates;
//    }

//    public String getRpqsDownloadUrl() {
//        return CollectivityAction.RPQS_DOWNLOAD_URL;
//    }

//    public String getRpqsDownloadUrlFilled(Integer pCollectivityId, Integer pChosenExerciseId, Integer pRpqsId) {
//        return CollectivityAction.RPQS_DOWNLOAD_URL + "?id=" + pCollectivityId + "&chosenExerciseId=" + pChosenExerciseId + "&rpqsId=" + pRpqsId;
//    }

//    public boolean isCanViewMandates() {
//        return canViewMandates;
//    }
//
//    public void setCanViewMandates(boolean canViewMandates) {
//        this.canViewMandates = canViewMandates;
//    }

//    public TerritoryDto getTerritory() {
//        return territory;
//    }
//
//    public void setTerritory(TerritoryDto territory) {
//        this.territory = territory;
//    }

//    /**
//     * @param territory
//     * @return collectivity territory id
//     */
//    protected int getCollectivityTerritoryId(TerritoryDto territory) {
//
//        int collectivityTerritoryId = -1;
//        if (territory != null) {
//            collectivityTerritoryId = territory.getId();
//        }
//        return collectivityTerritoryId;
//
//    }

//    /**
//     * @param territory
//     * @return true if current user can view the mandate list
//     */
//    protected boolean computeCanViewMandates(UserDto currentUser, TerritoryDto territory) {
//
//        boolean canViewMandates = false;
//
//        // check user right
//        if (currentUser != null && currentUser.getType().getIncludedTerritoryTypes().contains(territory.getType())) {
//            try {
//                canViewMandates = checkUserRight(Right.ViewMandates, territory, exercise);
//            } catch (SispeaException lEx) {
//                canViewMandates = false;
//            }
//        }
//
//        return canViewMandates;
//
//    }

}
