package fr.onema.sispea.struts.exchange.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.ActionInvocation;
import org.apache.struts2.dispatcher.StreamResult;

/**
 * This class for result-type="TextFileDownloadStream"
 *
 * It extends StreamResult Used to download file as a stream.
 */
public class TextFileDownloadStream extends StreamResult {

    public static final String STREAM_CONTENT_TYPE_TEXT = "text/txt";

    private static final long serialVersionUID = 1L;

    @Override
    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        // Get name of downloaded file 
        String downloadedFileName = (String) invocation.getStack().findValue(conditionalParse("fileName", invocation));

        contentDisposition = "attachment; filename=\"" + downloadedFileName + "\"";

        // Get file size
        contentLength = "" + invocation.getStack().findValue(conditionalParse("fileSize", invocation));

        // Get type of file
        contentType = "" + invocation.getStack().findValue(conditionalParse("contentType", invocation));

        /*
            Executes the result given a final location
            (jsp page, action, etc) and
            the action invocation (the state in which
            the action was executed).
        */

        super.doExecute(finalLocation, invocation);

    }

}
