package fr.onema.sispea.struts.common.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.struts.common.menu.MenuConstants;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * This class is bearing contact properties.
 *
 * @author CS
 */
public class MenuBean implements Serializable {

    /**
     * Generated serial version ID. To be used if the type does not undergo
     * structural changes since its first release.
     */
    private static final long serialVersionUID = 1L;

    /**
     * default visible value
     */
    protected boolean defaultVisibleValue = false;

    /**
     * visible ?
     */
    protected boolean visible = false;

    /**
     * activate ?
     */
    protected boolean activate = false;

    /**
     * open ?
     */
    protected boolean open = false;

    /**
     * SubMenu list
     */
    protected List<MenuBean> subMenu = new ArrayList<>();

    /**
     * link to parent
     */
    protected MenuBean parent = null;

    /**
     * color of menu
     */
    protected int color = 77;

    /**
     * color of menu
     */
    protected String key;

    /**
     * color of menu
     */
    protected String url;

    /**
     * internalUrl ?
     */
    protected boolean internalUrl = false;

    /**
     * url parameters type
     */
    protected String urlParameters = MenuConstants.NO_PARAMETER;

    /**
     * Add MenuBean in subMenu
     */
    public void add(MenuBean pBean) {
        pBean.parent = this;
        subMenu.add(pBean);
    }

    /**
     * hidden menu and all subMenu
     */
    public void hideAll() {
        // hide this
        visible = false;
        // hide childs
        for (MenuBean lMenu : getSubMenu()) {
            lMenu.hideAll();
        }
    }

    /**
     * close menu
     */
    public void close() {
        // close current menu
        open = false;

        // close childs
        for (MenuBean lSubMenu : subMenu) {
            lSubMenu.close();
        }
    }

    /**
     * try to show a menu with key. If shown, current menu is shown
     *
     * @param pKey
     * @return true if a sub menu or this menu is shown, false else
     */
    public boolean show(String pKey) {

        // init result
        Boolean lRes = false;

        // search for sub menu
        for (MenuBean lSubMenu : subMenu) {
            if (lSubMenu.show(pKey)) {
                // sub menu has been shown
                visible = true;
                lRes = true;
            }
        }

        // check current menu
        if (getKey().equals(pKey)) {
            visible = true;
            lRes = true;
        }

        // result
        return lRes;

    }

    /**
     * search for activated menu and set it to activate = false
     *
     * @return
     */
    public void deactivate() {
        // search for sub menu
        for (MenuBean lSubMenu : subMenu) {
            lSubMenu.deactivate();
        }
        // current menu
        setActivate(false);
    }

    /**
     * try to open a menu with key. If opened, current menu is open
     *
     * @param pKey
     * @return true if a sub menu or this menu is opened, false else
     */
    public boolean open(String pKey) {

        // init result
        Boolean lRes = false;

        // search for sub menu
        for (MenuBean lSubMenu : subMenu) {
            if (lSubMenu.open(pKey)) {
                lRes = true;
            }
        }

        // check current menu
        if (getKey().equals(pKey)) {
            // current menu should be opened and activated
            activate = true;
            lRes = true;
        }

        // this menu is activated or a sub menu is opened, so open this
        if (lRes) {
            open = true;
            visible = true;
            activate = true;
        } else {
            // restore default value
            visible = defaultVisibleValue;
        }

        // result
        return lRes;
    }

    /**
     * return the first sub menu with key
     *
     * @param pKey
     * @return
     */
    public MenuBean getMenu(String pKey) {

        // init result
        MenuBean lRes = null;

        // check this
        if (getKey().equals(pKey)) {
            lRes = this;
        } else {

            // check sub menu
            for (MenuBean lMenu : subMenu) {
                // search in sub menu
                lRes = lMenu.getMenu(pKey);
                // found ?
                if (lRes != null) {
                    break;
                }
            }
        }

        // result
        return lRes;

    }

    /**
     * return true if contains is activated
     *
     * @return
     */
    public boolean containsActivated() {
        // init result
        Boolean lRes = false;

        // check if this is activated
        if (activate) {
            lRes = true;
        } else {
            // look for contained menus
            // check sub menu
            for (MenuBean lMenu : subMenu) {
                if (lMenu.containsActivated()) {
                    lRes = true;
                    break;
                }
            }
        }

        // result
        return lRes;
    }

    // Getters and setters

    public boolean isOpen() {
        return open;
    }

    public void setOpen(boolean pOpen) {
        open = pOpen;
    }

    /**
     * return true if open
     *
     * @param pKey
     * @return
     */
    public boolean isOpen(String pKey) {
        // init result
        Boolean lRes = false;
        // get menu
        MenuBean lMenu = getMenu(pKey);
        // test menu
        if (lMenu != null) {
            lRes = lMenu.isOpen();
        }
        // result
        return lRes;
    }

    /**
     * set open value
     *
     * @param pOpen
     * @param pKey
     */
    public void setOpen(boolean pOpen, String pKey) {
        // get menu
        MenuBean lMenu = getMenu(pKey);
        // test menu
        if (lMenu != null) {
            lMenu.setOpen(pOpen);
        }
    }

    public boolean isVisible() {
        return visible;
    }

    public void setVisible(String pVisible) {
        visible = pVisible.equals("true");
    }

    /**
     * return true if visible
     *
     * @param pKey
     * @return
     */
    public boolean isVisible(String pKey) {
        // init result
        Boolean lRes = false;
        // get menu
        MenuBean lMenu = getMenu(pKey);
        // test menu
        if (lMenu != null) {
            lRes = lMenu.isVisible();
        }
        // result
        return lRes;
    }

    public void setVisible(boolean pVisible) {
        visible = pVisible;
    }

    /**
     * set visibility
     *
     * @param pKey
     * @param pVisible
     */
    public void setVisible(String pKey, boolean pVisible) {
        MenuBean lMenu = getMenu(pKey);
        if (lMenu != null) {
            lMenu.setVisible(pVisible);
        }
    }

    public List<MenuBean> getSubMenu() {
        return subMenu;
    }

    public void setSubMenu(List<MenuBean> pSubMenu) {
        subMenu = pSubMenu;
    }

    public List<MenuBean> getVisibleSubMenu() {
        // init
        List<MenuBean> lRes = new ArrayList<>();

        // loop on sub menus
        for (MenuBean lMenuBean : subMenu) {
            if (lMenuBean.isVisible()) {
                lRes.add(lMenuBean);
            }
        }

        // result
        return lRes;
    }

    public int getColor() {
        return color;
    }

    public void setColor(int pColor) {
        color = pColor;
    }

    /**
     * get color
     *
     * @param pKey
     * @return
     */
    public int getColor(String pKey) {
        // init result
        int lRes = -1;
        // get menu
        MenuBean lMenu = getMenu(pKey);
        // test menu
        if (lMenu != null) {
            lRes = lMenu.getColor();
        }
        // result
        return lRes;
    }

    public void setColor(String pColor) {
        color = Integer.valueOf(pColor);
    }

    public MenuBean getParent() {
        return parent;
    }

    public void setParent(MenuBean pParent) {
        parent = pParent;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String pKey) {

        key = pKey;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String pUrl) {
        url = pUrl;
    }

    /**
     * get url
     *
     * @param pKey
     * @return
     */
    public String getUrl(String pKey) {
        // init result
        String lRes = "";
        // get menu
        MenuBean lMenu = getMenu(pKey);
        // test menu
        if (lMenu != null) {
            lRes = lMenu.getUrl();
        }
        // result
        return lRes;
    }

    /**
     * jsp url
     *
     * @param pKey
     * @return
     */
    public String jspUrl(String pKey) {
        return getUrl(pKey);
    }

    /**
     * get jsp url
     *
     * @param pKey
     * @return
     */
    public String getJspUrl(String pKey) {
        return getUrl(pKey);
    }

    public boolean getInternalUrl() {
        return internalUrl;
    }

    public void setInternalUrl(boolean pInternalUrl) {
        internalUrl = pInternalUrl;
    }

    /**
     * return true if internal url
     *
     * @param pKey
     * @return
     */
    public boolean isInternalUrl(String pKey) {
        // init result
        Boolean lRes = false;
        // get menu
        MenuBean lMenu = getMenu(pKey);
        // test menu
        if (lMenu != null) {
            lRes = lMenu.getInternalUrl();
        }
        // result
        return lRes;
    }

    public void setFileInternalUrl(String pInternalUrl) {
        internalUrl = Boolean.valueOf(pInternalUrl);
    }

    public boolean isActivate() {
        return activate;
    }

    public void setActivate(boolean pActivate) {
        activate = pActivate;
    }

    /**
     * return true if activated
     *
     * @param pKey
     * @return
     */
    public boolean isActivate(String pKey) {
        // init result
        Boolean lRes = false;
        // get menu
        MenuBean lMenu = getMenu(pKey);
        // test menu
        if (lMenu != null) {
            lRes = lMenu.isActivate();
        }
        // result
        return lRes;
    }

    public boolean isDefaultVisibleValue() {
        return defaultVisibleValue;
    }

    public void setDefaultVisibleValue(String pDefaultVisibleValue) {
        defaultVisibleValue = Boolean.valueOf(pDefaultVisibleValue);
    }

    public String getUrlParameters() {
        return urlParameters;
    }

    public void setUrlParameters(String pUrlParameters) {
        urlParameters = pUrlParameters;
    }

}
