package fr.onema.sispea.struts.common.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.service.data.ExerciseDto;
import org.apache.log4j.Logger;

/**
 * This action handles the NCS test update
 *
 * @author CS
 */
public class UpdateTestNCSAction extends AbstractTestNCSAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(UpdateTestNCSAction.class);

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("update sand box - doExecute");
        }

        manageExercises();
        ExerciseDto lExercise = exerciseService.readExercise(exerciseId);

        if (lExercise != null) {
            addActionMessage("Nouveau nom : " + name + " pour l'anée " + lExercise.getYear());
        } else {
            addActionError("L'exercice n'existe pas ! ");
        }

        // result
        return Action.SUCCESS;
    }

}
