package fr.onema.sispea.struts.common.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.struts.AbstractSispeaAction;
import org.apache.log4j.Logger;

/**
 * This action handles the full screen mode updating.
 *
 * @author CS
 */
public class UpdateFullScreenAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(UpdateFullScreenAction.class);

    /**
     * the full screen param
     */
    private boolean fullScreen;

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("update full screen - doExecute");
        }

        // update session
        getSispeaSession().setFullScreen(fullScreen);

        // message
        if (getSispeaSession().isFullScreen()) {
            addActionMessage(getText("fr.onema.sispea.updateFullScreen.full"));
        } else {
            addActionMessage(getText("fr.onema.sispea.updateFullScreen.small"));
        }

        // result
        return Action.SUCCESS;
    }

    public boolean isFullScreen() {
        return fullScreen;
    }

    public void setFullScreen(boolean pFullScreen) {
        fullScreen = pFullScreen;
    }

}
