package fr.onema.sispea.struts.common.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.user.CryptedLoginDto;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

import java.util.List;
import java.util.Map;

/**
 * This action handles the user login validity test.
 * It tests if the user name/password is valid.
 *
 * @author CS
 */
public class UpdateForgottenPasswordAction extends AbstractForgottenPasswordAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(UpdateForgottenPasswordAction.class);

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("showforgottenPassword - doExecute");
        }

        // menu
        openMenu(MenuConstants.MENU_KEY_CONNECTION);

        // email tested by validator
        // read users
        List<UserDto> lUsers = userService.readUsersFromMail(email);

        // tests if no users
        if ((lUsers == null) || (lUsers.size() == 0)) {
            addActionError(getText("fr.onema.sispea.common.forgottenPassword.noUsers"));
        } else {
            try {
                // send notification email
                Map<Integer, CryptedLoginDto> mapLogins = userService.notifyUsersForPasswordReinit(email, lUsers, getLocale().getLanguage());

                // success message ?
                addActionMessage(getText("fr.onema.sispea.common.forgottenPassword.message", null, Integer.valueOf(mapLogins.size()).toString()));

            } catch (SispeaException lEx) {
                addActionError(getText(lEx.getMessage()));
            }
        }

        // result
        return Action.SUCCESS;
    }

}
