package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.data.IndicatorDto;
import fr.onema.sispea.service.data.SynthDisplayDto;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

import java.util.List;
import java.util.Map;

/**
 * This action handles the synthesis display administration update.
 *
 * @author CS
 */
public class UpdateSynthDisplayAction extends AbstractSynthDisplayAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(UpdateSynthDisplayAction.class);

    /**
     * the chosen elements list (indicatorId_exerciseId_visibility) selected in checkbox
     * the visibility of all elements are "true"
     */
    protected List<String> synthDisplayList;

    /**
     * Exercices indexed by their id.
     */
    protected Map<Integer,ExerciseDto> exercicesById;

    /**
     * Indicators indexed by their id.
     */
    protected Map<Integer,IndicatorDto> indicatorsById;

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("update synth display");
        }

        // init result
        String lRes = Action.SUCCESS;

        // open menu
        openMenu(MenuConstants.MENU_KEY_SYNTHDISPLAY);

        // check user right
        if (!checkUserRight(Right.Manage)) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        try {
            // view
            manageViewAction();

            // set to false each synthDisplay of the competence
            for (SynthDisplayDto lSynthDisplay : synthDisplays) {

                IndicatorDto indicator = lSynthDisplay.getIndicator();
                if (indicator.getCompetence().getId().equals(chosenCompetenceId)) {
                    Integer exerciseId = lSynthDisplay.getExercise().getId();
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Set to false synthDisplay for exercise %d / indicator: %s-%d", exerciseId, indicator.getType(), indicator.getId()));
                    }
                    indicatorService.updateSynthDisplay(exerciseId, indicator.getId(), false);
                }

            }

            // set to true the synthDisplays checked
            if (synthDisplayList != null && synthDisplayList.size() > 0) {

                for (String lStrCheckBox : synthDisplayList) {

                    // split check box value to get Indicator ID and Exercise ID
                    String[] s = lStrCheckBox.split("_");
                    Integer indicatorId;
                    Integer exerciseId;
                    try {
                        indicatorId = Integer.parseInt(s[0]);
                        exerciseId = Integer.parseInt(s[1]);
                    } catch (Exception lEx) {
                        throw new SispeaException("fr.onema.sispea.jsp.admin.synthDisplay.error.wrongCheckBoxValue");
                    }

//                    if (indicatorId == null || exerciseId == null) {
//                        throw new SispeaException("fr.onema.sispea.jsp.admin.synthDisplay.error.wrongValues");
//                    }

                    // check exercise param
                    ExerciseDto lExercise = exercicesById.get(exerciseId);
//                    try {
//                        lExercise = exerciseService.readExercise(exerciseId);
//                    } catch (Exception lEx) {
//                        lExercise = null;
//                    }
                    if (lExercise == null) {
                        throw new SispeaException("fr.onema.sispea.jsp.admin.synthDisplay.error.wrongExerciseId");
                    }

                    // check indicator param
                    IndicatorDto indicator = indicatorsById.get(indicatorId);
//                    try {
//                        indicator = indicatorService.readIndicator(indicatorId);
//                    } catch (Exception lEx) {
//                        indicator = null;
//                    }
                    if (indicator == null) {
                        throw new SispeaException("fr.onema.sispea.jsp.admin.synthDisplay.error.wrongIpId");
                    }

                    // founded synth display ?
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Set to true synthDisplay for exercise %s / indicator: %s-%d", exerciseId, indicator.getType(), indicatorId));
                    }
                    indicatorService.updateSynthDisplay(exerciseId, indicatorId, true);

                }
            }

            // reload
            manageViewAction();

        } catch (SispeaException lEx) {
            lRes = Action.INPUT;
            String lMessage = getText("fr.onema.sispea.jsp.admin.synthDisplay.error.general", "", getText(lEx.getMessage()));
            addActionError(lMessage);
        }

        // result
        return lRes;
    }

    public List<String> getSynthDisplayList() {
        return synthDisplayList;
    }

    public void setSynthDisplayList(List<String> pSynthDisplayList) {
        synthDisplayList = pSynthDisplayList;
    }

    @Override
    protected void manageViewAction() throws SispeaException {
        super.manageViewAction();

        exercicesById = Maps.uniqueIndex(exercises, new Function<ExerciseDto, Integer>() {

            @Override
            public Integer apply(ExerciseDto input) {
                return input.getId();
            }
        });

        indicatorsById = Maps.uniqueIndex(allIndicators, new Function<IndicatorDto, Integer>() {

            @Override
            public Integer apply(IndicatorDto input) {
                return input.getId();
            }
        });

    }

}
