package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.SliceLeveledDto;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import fr.onema.sispea.util.constants.NumberUtils;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * This action handles the synthesis relevant levels administration visualization.
 *
 * @author CS
 */
public class UpdateRelevantLevelsAction extends AbstractRelevantLevelsAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(UpdateRelevantLevelsAction.class);

    /**
     * the error fields prefix
     */
    private static final String ERROR_LEVEL_FIELD_PREFIX = "sliceErrorLevel";

    private static final String ERROR_RATE_FIELD_PREFIX = "sliceErrorRate";

    private static final String ERROR_SPEACOUNT_FIELD_PREFIX = "sliceErrorSpeaCount";

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("update relevant levels");
        }

        // init result
        String lRes = Action.SUCCESS;

        // open menu
        openMenu(MenuConstants.MENU_KEY_RELEVANTLEVELS);

        // check user right
        if (!checkUserRight(Right.Manage)) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        try {

            // load competences and check the chosen one
            checkCompetence();

            // get Slices from db
            List<SliceLeveledDto> lDbSlices = indicatorService.findSliceLeveledByCompetence(competence.getId());

            // check and copy str relevant levels
            boolean lDoSave = true;
            for (SliceLeveledDto lSlice : slices) {
                boolean lError = false;

                // copy level in db slices, error or not !
                boolean lFound = false;
                for (Iterator<SliceLeveledDto> iterator2 = lDbSlices.iterator(); iterator2.hasNext() && !lFound; ) {
                    SliceLeveledDto lDbSlice = iterator2.next();

                    if (lDbSlice.getId() == lSlice.getId()) {

                        // found !
                        lFound = true;
                        String lSliceName = lDbSlice.getNameSlice();
                        String lSliceId = Integer.valueOf(lSlice.getId()).toString();

                        // copy input value
                        lDbSlice.setStrRelevantLevel(lSlice.getStrRelevantLevel());
                        lDbSlice.setStrRelevantRate(lSlice.getStrRelevantRate());
                        lDbSlice.setStrSpeaCount(lSlice.getStrSpeaCount());

                        // check relevant level value
                        Integer lRelevantLevel = null;
                        try {
                            if (lSlice.getStrRelevantLevel() != null && lSlice.getStrRelevantLevel().length() > 0) {
                                // test format
                                lRelevantLevel = NumberUtils.stringToInteger(lSlice.getStrRelevantLevel());
                            }
                        } catch (SispeaException lEx) {
                            // not an integer !
                            lError = true;
                            manageInputError(lDbSlice.getStrRelevantLevel(), lSliceName, lSliceId, "level", ERROR_LEVEL_FIELD_PREFIX);
                        }

                        // check relevant rate value
                        Integer lRelevantRate = null;
                        try {
                            if (lSlice.getStrRelevantRate() != null && lSlice.getStrRelevantRate().length() > 0) {
                                // test format
                                lRelevantRate = NumberUtils.stringToInteger(lSlice.getStrRelevantRate());
                            }
                        } catch (SispeaException lEx) {
                            // not an integer !
                            lError = true;
                            manageInputError(lDbSlice.getStrRelevantRate(), lSliceName, lSliceId, "rate", ERROR_RATE_FIELD_PREFIX);
                        }

                        // check spea count value
                        Integer lSpeaCount = null;
                        try {
                            if (lSlice.getStrSpeaCount() != null && lSlice.getStrSpeaCount().length() > 0) {
                                // test format
                                lSpeaCount = NumberUtils.stringToInteger(lSlice.getStrSpeaCount());
                            }
                        } catch (SispeaException lEx) {
                            // not an integer !
                            lError = true;
                            manageInputError(lDbSlice.getStrSpeaCount(), lSliceName, lSliceId, "speaCount", ERROR_SPEACOUNT_FIELD_PREFIX);
                        }

                        if (!lError) {
                            lDbSlice.setRelevantLevel(lRelevantLevel);
                            lDbSlice.setRelevantRate(lRelevantRate);
                            lDbSlice.setSpeaCount(lSpeaCount);
                        }
                    }
                }

                // error ?
                if (lError) {
                    lDoSave = false;
                }
            }

            // replace slices with db slices updated
            slices = lDbSlices;

            // save ?
            if (lDoSave) {

                // save
                indicatorService.saveSlices(competence.getId(), slices);

                // message
                addActionMessage(getText("fr.onema.sispea.jsp.admin.relevantLevels.message.success"));
            }

        } catch (SispeaException lEx) {
            lRes = Action.INPUT;
            addActionError(lEx.getMessage());
        }

        // result
        return lRes;

    }

    protected void manageInputError(String pInputErrorValue, String pSliceName, String pSliceId, String pTranslationSuffixKey, String pErrorPrefix) {

        List<Object> lArgs = new ArrayList<>();
        lArgs.add(pInputErrorValue);
        lArgs.add(pSliceName);
        String lStrMessage = getText("fr.onema.sispea.jsp.admin.relevantLevels.error.wrongInteger." + pTranslationSuffixKey, lArgs);
        String lFieldName = pErrorPrefix + pSliceId;
        addActionError(lStrMessage);
        addFieldError(lFieldName, lStrMessage);

    }

}
