package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.exchange.thread.AsynchronousService;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * This action handles the exchange queue updating.
 * maitenance action
 *
 * @author CS
 */
public class UpdateExchangeQueueAction extends AbstractExchangeQueueAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(UpdateExchangeQueueAction.class);

    @Autowired
    @Qualifier("speaComparatorGeneratorService")
    protected transient AsynchronousService speaComparatorGeneratorService;
    
    /**
     * The exchange description to delete
     */
    private String descriptionToDelete;

    @Override
    protected String doExecute() throws Exception {

        // init
        String lResult = Action.SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("update exchange queue action");
        }

        // check rights
        if (!checkUserRight(Right.Manage)) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        try {
            // supprimer
            deleteExchange(descriptionToDelete);

        } catch (SispeaException lEx) {
            lResult = Action.INPUT;
            String lMessage = getText("fr.onema.sispea.jsp.admin.exchangeQueue.error.main", "", getText(lEx.getMessage()));
            addActionError(lMessage);
        }

        try {
            // lire les échanges
            checkExchanges();

        } catch (SispeaException lEx) {
            lResult = Action.INPUT;
            String lMessage = getText("fr.onema.sispea.jsp.admin.exchangeQueue.error.main", "", getText(lEx.getMessage()));
            addActionError(lMessage);
        }

        // open menu
        openMenu(MenuConstants.MENU_KEY_EXCHANGESQUEUE);

        // result
        return lResult;
    }

    public String getDescriptionToDelete() {
        return descriptionToDelete;
    }

    public void setDescriptionToDelete(String pDescriptionToDelete) {
        descriptionToDelete = pDescriptionToDelete;
    }

    /**
     * Delete if possible the exchange corresponding to description
     *
     * @param pDescriptionToDelete
     * @throws SispeaException
     */
    protected void deleteExchange(String pDescriptionToDelete) throws SispeaException {

        // delete
        try {
            fileExchangeService.deleteExchange(pDescriptionToDelete);
        } catch (SispeaException e) {
            // We do nothing, because maybe it's a process instead...

        }

        try {
            usersExportGeneratorService.deleteProcess(pDescriptionToDelete);
        } catch (SispeaException e) {
            // We do nothing, because maybe it's a comparator process instead...
        }

        try {
            speaComparatorGeneratorService.deleteProcess(pDescriptionToDelete);
        } catch (SispeaException e) {
            // We do nothing, because maybe it's a comparator process instead...
        }
    }

}
