package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

/**
 * This action handles the new spea management.
 * It allows the end user to show the new spea management.
 *
 * @author CS
 */
public class ShowNewSpeaAction extends AbstractNewSpeaAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowNewSpeaAction.class);

    @Override
    protected String doExecute() throws Exception {

        String lRes = Action.SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("show newSpea");
        }

        // set the menu
        openMenu(MenuConstants.MENU_KEY_NEWSPEA);

        // check rights
        if (!checkUserRight(Right.Manage)) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        try {
            // load exercises
            exercises = exerciseService.readNotCurrentExercises();

            //load territories
            checkUsersSelections();

            loadExcerciseList();

            loadSelectedTerritories();

        } catch (SispeaException e) {
            lRes = Action.INPUT;
            addActionError(getText(e.getMessage()));
        }

        // result
        return lRes;
    }

}
