package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.DashBoardConstants;
import fr.onema.sispea.service.data.DashBoardTabDto;
import fr.onema.sispea.service.referential.TerritoryPairDto;
import fr.onema.sispea.service.referential.TerritoryType;
import fr.onema.sispea.service.search.SearchTerritoryResultDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * This action handles the Dashboard visualization.
 *
 * @author CS
 */
public class ShowDynamicDashboardAction extends AbstractDashboardAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowDynamicDashboardAction.class);

    /**
     * The tab id to display
     */
    protected Integer tabId;

    @Override
    protected String doExecute() throws Exception {

        // init
        String lRes = SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("show Dashboard");
        }

        // open menu
        openMenu(MenuConstants.MENU_KEY_DASHBOARD);

        // check rights
        if (!checkIfUserCanViewDashBoard()) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        try {
            // load exercise
            loadExercises();

            // load competence and indicator
            loadIndicators();

            // load available territories and chosen territory
            loadTerritories();

            // check tab id
            checkTabId();

            // check chosen territory
            if (territory != null && exercise != null) {

                // search for speas
                List<SearchTerritoryResultDto> lSearchResults = null;

                // load all dashboard spea contained if not yet
                if (getSispeaSession().getTerritoryIncludedSpeasIds(territory, exercise) != null) {
                    lSearchResults = getSispeaSession().getTerritoryIncludedSpeasIds(territory, exercise);
                }
                if (lSearchResults == null) {

                    // load included speas
                    lSearchResults = territoryService.search(territory.getId(), territory.getType(),
                                                             null, null, TerritoryType.SPEA, null, exercise.getId(), null,
                                                             getCurrentUser().getId(), true);
                    List<TerritoryPairDto> lPairs = SearchTerritoryResultDto.getPairs(lSearchResults);

                    // build a list of spea ids
                    List<Integer> lSpeaTerritoryIds = new ArrayList<>();
                    for (TerritoryPairDto lTerritoryPair : lPairs) {
                        lSpeaTerritoryIds.add(lTerritoryPair.getChildTerritoryId());
                    }

                    // add to territory
                    territory.setIncludedSpeaTerritoryIds(lSpeaTerritoryIds);

                    // add ids
                    getSispeaSession().setTerritoryIncludedSpeasIds(territory, exercise, lSearchResults);
                }

                // build the dashBoard bean
                dashBoard = searchService.buildDashBoard(competenceId, territory,
                                                         exercise, getCurrentUser(), tabId, lSearchResults);
            }
        } catch (SispeaException lEx) {
            String lMessage = getText("fr.onema.sispea.jsp.admin.dashboard.message.error", "", lEx.getMessage());
            logger.error(lMessage);
            addActionError(lMessage);
            lRes = INPUT;
        }

        // result
        return lRes;

    }

    /**
     * check if tab id is set and set it to default  if not
     *
     * @throws SispeaException
     */
    protected void checkTabId() throws SispeaException {

        // check chosen tab
        if (chosenTabOrder == null) {
            chosenTabOrder = DashBoardConstants.TAB_ORDER_GENERAL;
        }

        // proper tab id ?
        List<DashBoardTabDto> lAllowedTabIds = getTabs();
        Boolean lFound = false;
        for (Iterator<DashBoardTabDto> iterator = lAllowedTabIds.iterator(); iterator.hasNext() && !lFound; ) {
            DashBoardTabDto lDashBoardTab = iterator.next();
            if (lDashBoardTab.getOrder().equals(chosenTabOrder)) {
                lFound = true;
                tabId = lDashBoardTab.getId();
//                lDashBoardTab.setVisible(true);
            }
        }
        if (!lFound) {
            throw new SispeaException(getText("fr.onema.sispea.jsp.admin.dashboard.message.wrongTabId"));
        }
    }

    public Integer getTabId() {
        return tabId;
    }

    public void setTabId(Integer pTabId) {
        tabId = pTabId;
    }
}
