package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

public class ShowDataListsAction extends AbstractDataListsAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(AbstractDataListsAction.class);

    @Override
    protected String doExecute() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("show Data lists");
        }

        // set the menu
        openMenu(MenuConstants.MENU_KEY_DATALISTS);

        // check rights
        if (!checkUserRight(Right.Manage)) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        try {
            checkUsersSelections();

            // check if deletion
            if (submitValue != null && submitValue.equals(getText("fr.onema.sispea.jsp.admin.dataLists.buttons.delete"))) {
                // Delete list
                if (selectedListId != null && selectedListId > 0) {
                    indicatorService.removeDataListById(selectedListId);
                    selectedListId = null;
                    addActionMessage(getText("fr.onema.sispea.jsp.admin.dataLists.message.delete"));
                } else {
                    addActionError(getText("fr.onema.sispea.jsp.admin.dataLists.error.noListSelected"));
                }
            }

            loadLists();
            loadCompetenceList();
            loadExerciseList();

            if (submitValue != null && submitValue.equals(getText("fr.onema.sispea.jsp.admin.dataLists.buttons.clone"))) {

                selectedListId = null;
                currentList.setId(null);

            }

            manageViewActions();

        } catch (SispeaException lEx) {
            String lMessage = getText("fr.onema.sispea.jsp.admin.dataLists.error", "", lEx.getMessage());
            logger.error(lMessage);
            addActionError(lMessage);
            return Action.INPUT;
        }

        // result
        return Action.SUCCESS;
    }

}
