package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.exchange.DashboardExportParameters;
import fr.onema.sispea.service.exchange.FileExchangeService;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * This action handles the Dashboard visualization.
 *
 * @author CS
 */
public class ShowDashboardAction extends AbstractDashboardAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowDashboardAction.class);

    @Autowired
    protected transient FileExchangeService fileExchangeService;

    /**
     * nb exchanges in queue
     */
    protected int queueSize;


    @Override
    protected String doExecute() throws Exception {

        // init
        String lRes = Action.SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("show Dashboard");
        }

        // open menu
        openMenu(MenuConstants.MENU_KEY_DASHBOARD);

        // check rights
        if (!checkIfUserCanViewDashBoard()) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        try {
            // load exercise
            loadExercises();

            // load competence and indicator
            loadIndicators();

            // load available territories and chosen territory
            loadTerritories();

            // export ?
            if (submitValue != null &&
                (submitValue.equals(getText("fr.onema.sispea.jsp.admin.dashboard.submit.export")) || submitValue.equals(getText("fr.onema.sispea.jsp.admin.dashboard.submit.exportAg")))) {

                // export params
                List<TerritoryDto> lTerritories = new ArrayList<>();
                lTerritories.add(territory);

                // download params
                DashboardExportParameters lParameters = new DashboardExportParameters(
                        getCurrentUser(),
                        true,
                        territory,
                        getLocale().getLanguage(),
                        exercise,
                        competence,
                        null,
                        getText("fr.onema.sispea.service.exchange.fileName.dateFormat"),
                        submitValue.equals(getText("fr.onema.sispea.jsp.admin.dashboard.submit.exportAg"))
                );

                // export !
                queueSize = fileExchangeService.downloadDashboard(lParameters);

                // info
                addActionMessage(getText("fr.onema.sispea.jsp.admin.dashboard.message.info.export", "",
                                         Integer.valueOf(queueSize).toString()));
            }

            // check chosen territory
            if (territory != null && exercise != null) {

                // build the dashBoard bean
//                dashBoard = searchService.buildDashBoard(competenceId, territory,
//                        exercise, getCurrentUser(), null);
                dashBoard = searchService.buildEmptyDashBoard(getCurrentUser());

            }
        } catch (SispeaException lEx) {
            String lMessage = getText("fr.onema.sispea.jsp.admin.dashboard.message.error", "", lEx.getMessage());
            logger.error(lMessage);
            addActionError(lMessage);
            lRes = Action.INPUT;
        }

        // result
        return lRes;

    }

}
