package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

public class ShowAdminPublicationAction extends AbstractAdminPublicationAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowAdminPublicationAction.class);

    @Override
    protected String doExecute() throws Exception {
        // init
        String lResult = Action.SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("show admin publication action");
        }

        // check rights
        if (!checkUserRight(Right.Manage)) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        //init
        result = null;

        // open menu
        openMenu(MenuConstants.MENU_KEY_ADMINPUBLICATION);

        // exercise
        checkExercise();

        // check admin publication
        checkAdminPublishType();

        // result
        return lResult;
    }
}
