package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.referential.ReferentialService;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * This action handles the new exercise management.
 * It allows the end user to change to a new exercise.
 *
 * @author CS
 */
public class ChangeExerciseAction extends AbstractExercisesAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ChangeExerciseAction.class);

    @Autowired
    protected transient ReferentialService referentialService;

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("change exercise");
        }

        // set the menu
        openMenu(MenuConstants.MENU_KEY_CHANGEEXERCISE);

        // check rights
        if (!checkUserRight(Right.Manage)) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        //Copy referential
        ExerciseDto currentExercise = exerciseService.getCurrentExercise();
        referentialService.copyReferential(currentExercise);

        // reload exercises
        nextExercise = Integer.valueOf(currentExercise.getYear() + 1).toString();
        exercises = exerciseService.readExercises();

        // result
        return Action.SUCCESS;
    }

}
