package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import org.apache.log4j.Logger;

/**
 * This class bundles an Importer in a separate thread.
 *
 * @author CS
 */
public class AdminThread implements Runnable {

//    /**
//     * The name of the thread.
//     */
//    public static final String THREAD_NAME = "Importer";

    private static final Logger logger = Logger.getLogger(AdminThread.class);

    /**
     * The importer to execute.
     */
    private Administrator administrator;

    /**
     * Default constructor.
     */
    public AdminThread() {
        super();
    }

    /**
     * Default constructor.
     */
    public AdminThread(Administrator pAdministrator) {
        this();
        administrator = pAdministrator;
    }

    @Override
    public void run() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Processing import");
            }
            administrator.process();
        } catch (Exception e) {
            logger.error("Error while processing admin task.", e);
        } finally {
            if (logger.isDebugEnabled()) {
                logger.debug("Processing terminated. The thread will die.");
            }
        }
    }

}
