package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.struts.AbstractSispeaAction;
import org.apache.log4j.Logger;
import org.apache.struts2.util.ServletContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.ServletContext;

/**
 * This action handles the new exercise management.
 * It allows the end user to change to a new exercise.
 *
 * @author CS
 *         //FIXME tc20150703 A supprimer ou simplifier on a un seul Adminstrator existant...
 */
public class AdminAction extends AbstractSispeaAction implements ServletContextAware {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(AdminAction.class);

    /**
     * the class name to instanciate
     */
    private String className;

    /**
     * The servlet context
     */
    private transient ServletContext context;

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("change exercise");
        }

        // check rights
        if (!checkUserRight(Right.Manage)) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        // init
        Thread myThread = null;

        try {
            // No running imports
            if (logger.isInfoEnabled()) {
                logger.info("Starting import manager in new thread");
            }

            if ((className == null) || (className.length() == 0)) {
                addActionMessage("No class name specified");
            } else {

                // create thread
                Administrator adminProcessToLaucnh = getAdministratorProcess(className);
                AdminThread adminProcess = new AdminThread(adminProcessToLaucnh);
                myThread = new Thread(adminProcess, className);

                // Run thread
                myThread.start();

                // succes message
                addActionMessage("thread started");
            }
        } catch (Exception e) {
            // Try to stop the thread
            String msg = "Error initializing the admin action thread : " + e.getMessage();
            addActionError(msg);
            logger.error(msg, e);
            try {
                if (myThread != null) {
                    myThread.interrupt();
                }
            } catch (Exception ex) {
                addActionError("Error stoping the import manager thread : " + ex.getMessage());
                logger.error("Error stoping the import manager thread", ex);
                // Do not throw anything.
            }
        }

        // result
        return Action.SUCCESS;
    }

    /**
     * @param pClassName
     * @return
     */
    protected Administrator getAdministratorProcess(String pClassName) {

        // init
        Administrator lRes;

        // spring context
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext(context);
        lRes = (Administrator) ctx.getBean(pClassName);

        // result
        return lRes;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String pClassName) {
        className = pClassName;
    }

    @Override
    public void setServletContext(ServletContext context) {
        this.context = context;
    }

}
