package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.data.ExerciseService;
import fr.onema.sispea.service.referential.ReferentialService;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.referential.TerritoryType;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.AbstractSispeaAction;
import fr.onema.sispea.struts.search.bean.BackType;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * This action handles the new spea management.
 * It allows the end user to show  new spea management.
 *
 * @author CS
 */
public abstract class AbstractNewSpeaAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

//    private static final Logger logger = Logger.getLogger(NewSpeaAction.class);

    @Autowired
    protected transient ExerciseService exerciseService;

    @Autowired
    protected transient ReferentialService referentialService;

    /**
     * exercise list
     */
    protected List<ExerciseDto> exercises;

    /**
     * the user selected territories
     */
    protected List<TerritoryDto> userSelection;

    /**
     * territory id to extract
     */
    protected Integer speaTerritoryId;

    /**
     * chosen exercise id
     */
    protected Integer chosenExerciseId;

    /**
     * the spea organism id processed
     */
    protected Integer speaOrgId;

    /**
     * Selected territory from "Enrichir"
     */
    protected Integer selectionId;

    protected Map<String, String> exerciseList;

    protected Map<String, String> selectedTerritories;

//    @Override
//    protected String doExecute() throws Exception {
//
//        if (logger.isDebugEnabled()) {
//            logger.debug("show newSpea should not be called");
//        }
//
//        // result
//        return Action.SUCCESS;
//    }

    /**
     * check user's selections and fill corresponding list
     *
     * @throws SispeaException
     */
    protected void checkUsersSelections() throws SispeaException {

        // connected ?
        UserDto lUser = getCurrentUser();
        if (lUser == null) {
            // not connected -> search in session
            userSelection = getSispeaSession().getSelectedTerritories();
        } else {
            // connected -> search in DB
            userSelection = referentialService.readUserSelections(lUser);

            // current user's territory ?
            if (lUser.getTerritory() != null) {

                // if current user territory not in list -> add it
                if (!userSelection.contains(lUser.getTerritory())) {
                    userSelection.add(lUser.getTerritory());
                }
            }
        }

        //delete from list if it's not a spea
        for (Iterator<TerritoryDto> iterator = userSelection.iterator(); iterator.hasNext(); ) {
            TerritoryDto lTerritory = iterator.next();
            if (lTerritory.getType() != TerritoryType.SPEA) {
                iterator.remove();
            }

        }

        // sort list
        Collections.sort(userSelection);

    }

    protected void loadSelectedTerritories() {
        selectedTerritories = new TreeMap<>();

        if (userSelection != null && userSelection.size() > 0) {

            for (TerritoryDto lTerritory : userSelection) {
                selectedTerritories.put(lTerritory.getId().toString(), lTerritory.getName());
            }
        }
    }

    protected void loadExcerciseList() throws SispeaException {
        exerciseList = new HashMap<>();
        List<ExerciseDto> lExercises = exerciseService.readNotCurrentExercises();
        for (ExerciseDto lExercise : lExercises) {
            exerciseList.put(lExercise.getId().toString(), lExercise.getYear().toString());
        }
    }

    public Map<String, String> getExerciseList() {
//
//        //init list
//        Map<String, String> exerciseList = new HashMap<>();
//
//        // get exercises
//        List<ExerciseDto> lExercises = exerciseService.readNotCurrentExercises();
//
//        for (ExerciseDto lExercise : lExercises) {
//            exerciseList.put(lExercise.getId().toString(), lExercise.getYear().toString());
//        }

        return exerciseList;
    }

    /**
     * @return the list of user's selected territories
     */
    public Map<String, String> getSelectedTerritories() {
//        // init result
//        Map<String, String> selectedTerritories = new TreeMap<>();
//
//        if (userSelection != null && userSelection.size() > 0) {
//
//            for (TerritoryDto lTerritory : userSelection) {
//                selectedTerritories.put(lTerritory.getId().toString(), lTerritory.getName());
//            }
//        }
//
//        // result
        return selectedTerritories;
    }

//    /**
//     * copy specifications of the territory for the current Exercise, to the Exercise in parameter
//     * return if it's well done
//     *
//     * @return boolean
//     * @throws SispeaException
//     */
//    public Integer processNewSpea(int pExerciseId, int pTerritoryId) throws SispeaException {
//
//
//        OrganismDto lOrganism = territoryService.getOrganismFromTerritoryId(pTerritoryId);
//        if (lOrganism.getType() != OrganismType.SPEA) {
//            throw new SispeaException("fr.onema.sispea.jsp.admin.newSpea.noSpeaTerritory");
//        }
//
//        referentialService.buildNewSpea(Integer.valueOf(pExerciseId).shortValue(), lOrganism.getId());
//
//        return lOrganism.getId();
//
//    }

    public List<ExerciseDto> getExercises() {
        return exercises;
    }

    public void setExercises(List<ExerciseDto> pExercises) {
        exercises = pExercises;
    }

    public List<TerritoryDto> getUserSelection() {
        return userSelection;
    }

    public void setUserSelection(List<TerritoryDto> pUserSelection) {
        userSelection = pUserSelection;
    }

    public Integer getSpeaTerritoryId() {
        return speaTerritoryId;
    }

    public void setSpeaTerritoryId(Integer pSpeaTerritoryId) {
        speaTerritoryId = pSpeaTerritoryId;
    }

    public Integer getChosenExerciseId() {
        return chosenExerciseId;
    }

    public void setChosenExerciseId(Integer pChosenExerciseId) {
        chosenExerciseId = pChosenExerciseId;
    }

    public Integer getSpeaOrgId() {
        return speaOrgId;
    }

    public void setSpeaOrgId(Integer pSpeaOrgId) {
        speaOrgId = pSpeaOrgId;
    }

    public Integer getBackPageId() {
        return BackType.newSpea.getId();
    }

    public Integer getSelectionId() {
        return selectionId;
    }

    public void setSelectionId(Integer pSelectionId) {
        selectionId = pSelectionId;
    }
}
