package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.common.AdminPublicationType;
import fr.onema.sispea.struts.referential.action.AbstractExerciseListAction;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractAdminPublicationAction extends AbstractExerciseListAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(AbstractExchangeQueueAction.class);

    /**
     * Today's date to initialize form
     */
    protected Date todayDate;

    /**
     * Date before which data has been marked as "checked"
     */
    protected String beforeDate;

    /**
     * List of origins types
     */
    protected Map<Integer, String> originList;

    /**
     * Selected type
     */
    protected String originType;

    /**
     * Selected type
     */
    protected AdminPublicationType publicationType;

    /**
     * Count of data to be published
     */
    protected Integer result;

//    @Override
//    protected String doExecute() throws Exception {
//
//        if (logger.isDebugEnabled()) {
//            logger.debug("admin publication - shouldn't be called");
//        }
//
//        // check rights
//        if (!checkUserRight(Right.Manage)) {
//            // message
//            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
//        }
//
//        // open menu
//        openMenu(MenuConstants.MENU_KEY_ADMINPUBLICATION);
//
//        // result
//        return Action.SUCCESS;
//    }

    /**
     * check the type to set for admin publication
     *
     * @throws SispeaException
     */
    protected void checkAdminPublishType() throws SispeaException {

        // default value
        if (originType == null) {
            originType = Integer.valueOf(AdminPublicationType.regular.getId()).toString();
        }

        try {
            publicationType = AdminPublicationType.parseFromId(Integer.valueOf(originType).intValue());
        } catch (Exception e) {
            throw new SispeaException("Le type de publication " + originType + "est inconnu !");
        }

    }

    protected AdminPublication getAdministratorProcess() {

        // init
        AdminPublication lRes;

        // spring context
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext(ServletActionContext.getServletContext());
        lRes = (AdminPublication) ctx.getBean("adminPublication");

        lRes.setBeforeDate(beforeDate);
        lRes.setCurrentUser(getCurrentUser());
        lRes.setLanguage(getLocale().getLanguage());
        lRes.setOriginType(publicationType);
        lRes.setExerciseId(exercise.getId());
        lRes.setBeforeDateFormat(getFormatDateOnly());

        // result
        return lRes;
    }

    public Date getTodayDate() {
        todayDate = new Date();
        return todayDate;
    }

    public void setTodayDate(Date pTodayDate) {
        todayDate = pTodayDate;
    }

    public Map<Integer, String> getOriginList() {
        if (originList == null || originList.size() == 0) {
            originList = new TreeMap<>();
            originList.put(AdminPublicationType.regular.getId(), getText(AdminPublicationType.regular.getLabelKey()));
            originList.put(AdminPublicationType.others.getId(), getText(AdminPublicationType.others.getLabelKey()));
        }

        return originList;
    }

    public Integer getResult() {
        return result;
    }

    public void setResult(Integer pResult) {
        result = pResult;
    }

    public String getBeforeDate() {
        return beforeDate;
    }

    public void setBeforeDate(String pBeforeDate) {
        beforeDate = pBeforeDate;
    }

    public String getOriginType() {
        return originType;
    }

    public void setOriginType(String pOriginType) {
        originType = pOriginType;
    }

    public String getOriginType(String pOriginId) {
        String lRes = null;
        if (pOriginId != null && pOriginId.length() > 0) {
            try {
                lRes = getOriginList().get(Integer.valueOf(pOriginId));

            } catch (Exception e) {
                lRes = null;
            }
        }
        return lRes;
    }

}
